/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.config;

import com.mojang.datafixers.util.Pair;
import fuzs.thinair.ThinAir;
import fuzs.thinair.helper.AirQualityLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> alwaysBreathingEntities;
    public static ForgeConfigSpec.BooleanValue enableSignalTorches;
    public static ForgeConfigSpec.IntValue drownedChoking;
    public static ForgeConfigSpec.DoubleValue soulFireRange;
    public static ForgeConfigSpec.DoubleValue soulCampfireRange;
    public static ForgeConfigSpec.DoubleValue soulTorchRange;
    public static ForgeConfigSpec.DoubleValue lavaRange;
    public static ForgeConfigSpec.DoubleValue netherPortalRange;
    private static Map<ResourceLocation, DimensionEntry> dimensionEntries;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        dimensions = builder.comment(new String[]{"Air qualities at different heights in different dimensions.", "The syntax is the dimension's resource location, the \"default\" air level in that dimension,", "then any number of height:airlevel pairs separated by commas.", "The air will have that quality starting at that height and above (until the next entry).", "The entries must be in ascending order of height.", "If a dimension doesn't have an entry here, it'll be assumed to be green everywhere."}).defineList("dimensions", Arrays.asList("minecraft:overworld=yellow,0:green,128:yellow", "minecraft:the_nether=yellow", "minecraft:the_end=red"), o -> {
            String s;
            return o instanceof String && CommonConfig.parseDimensionLine(s = (String)o) != null;
        });
        alwaysBreathingEntities = builder.comment(new String[]{"Entities that can always breathe.", "This is in addition to entities where `.canBreatheUnderwater()` returns true (so, fish and undead),", "and invulnerable players."}).defineList("alwaysBreathingEntities", Arrays.asList("minecraft:armor_stand", "minecraft:enderman", "minecraft:endermite", "minecraft:shulker", "minecraft:strider", "minecraft:ghast", "minecraft:piglin", "minecraft:hoglin", "minecraft:piglin_brute", "minecraft:blaze", "minecraft:magma_cube", "minecraft:ender_dragon", "minecraft:wither"), o -> {
            String s;
            return o instanceof String && ResourceLocation.m_135830_((String)(s = (String)o));
        });
        enableSignalTorches = builder.comment("Whether to allow right-clicking torches to make them spray particle effects").define("enableSignalTorches", true);
        drownedChoking = builder.comment("How much air a Drowned attack removes").defineInRange("drownedChoking", 100, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.push("Ranges");
        soulTorchRange = builder.comment("The radius a soul torch projects a bubble of blue air around it").defineInRange("soulTorchRange", 2.0, 0.0, 32.0);
        soulFireRange = builder.comment("The radius a soul fire projects a bubble of blue air around it").defineInRange("soulFireRange", 5.0, 0.0, 32.0);
        soulCampfireRange = builder.comment("The radius a soul campfire projects a bubble of blue air around it").defineInRange("soulCampfireRange", 9.0, 0.0, 32.0);
        lavaRange = builder.comment("The radius lava blocks project a bubble of red air around it").defineInRange("lavaRange", 5.0, 0.0, 32.0);
        netherPortalRange = builder.comment("The radius nether portal blocks project a bubble of green air around it").defineInRange("netherPortalRange", 5.0, 0.0, 32.0);
        builder.pop();
    }

    @Nullable
    private static Pair<ResourceLocation, DimensionEntry> parseDimensionLine(String line) {
        AirQualityLevel baseQuality;
        String[] dimensionVals = line.split("=");
        if (dimensionVals.length != 2) {
            ThinAir.LOGGER.warn("Couldn't parse dimension line {}: couldn't split across `=` into 2 parts", (Object)line);
            return null;
        }
        ResourceLocation dimkey = ResourceLocation.m_135820_((String)dimensionVals[0]);
        if (dimkey == null) {
            ThinAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid resource location", (Object)line, (Object)dimensionVals[0]);
            return null;
        }
        String[] heightAndRest = dimensionVals[1].split(",", 2);
        try {
            baseQuality = AirQualityLevel.valueOf(heightAndRest[0].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ThinAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid base air quality", (Object)line, (Object)heightAndRest[0]);
            return null;
        }
        ArrayList<Pair<Integer, AirQualityLevel>> heights = new ArrayList<Pair<Integer, AirQualityLevel>>();
        if (heightAndRest.length == 2) {
            String[] heightPairStrs = heightAndRest[1].split(",");
            Integer prevHeight = null;
            for (String heightPairStr : heightPairStrs) {
                AirQualityLevel quality;
                int height;
                String[] pairStr = heightPairStr.split(":");
                if (pairStr.length != 2) {
                    ThinAir.LOGGER.warn("Couldn't parse dimension line {}: couldn't use {} as a height entry", (Object)line, (Object)heightPairStr);
                    return null;
                }
                try {
                    height = Integer.parseInt(pairStr[0]);
                }
                catch (NumberFormatException e) {
                    ThinAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid int", (Object)line, (Object)pairStr[0]);
                    return null;
                }
                if (prevHeight != null && height <= prevHeight) {
                    return null;
                }
                prevHeight = height;
                try {
                    quality = AirQualityLevel.valueOf(pairStr[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    ThinAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid air quality", (Object)line, (Object)pairStr[1]);
                    return null;
                }
                heights.add((Pair<Integer, AirQualityLevel>)new Pair((Object)height, (Object)quality));
            }
        }
        return new Pair((Object)dimkey, (Object)new DimensionEntry(baseQuality, heights));
    }

    public static AirQualityLevel getAirQualityAtLevelByDimension(ResourceLocation dimension, int y) {
        if (dimensionEntries == null) {
            List lines = (List)dimensions.get();
            dimensionEntries = new HashMap<ResourceLocation, DimensionEntry>(lines.size());
            for (String line : (List)dimensions.get()) {
                Pair<ResourceLocation, DimensionEntry> entry = CommonConfig.parseDimensionLine(line);
                if (entry == null) {
                    ThinAir.LOGGER.warn("Somehow managed to get a bad dimension config past the validator?!");
                    continue;
                }
                dimensionEntries.put((ResourceLocation)entry.getFirst(), (DimensionEntry)entry.getSecond());
            }
        }
        if (dimensionEntries.containsKey(dimension)) {
            DimensionEntry entry = dimensionEntries.get(dimension);
            List<Pair<Integer, AirQualityLevel>> heights = entry.heights;
            for (int i = 0; i < heights.size(); ++i) {
                Pair<Integer, AirQualityLevel> heightPair = heights.get(heights.size() - i - 1);
                if (y < (Integer)heightPair.getFirst()) continue;
                return (AirQualityLevel)((Object)heightPair.getSecond());
            }
            return entry.baseQuality;
        }
        return AirQualityLevel.GREEN;
    }

    static {
        org.apache.commons.lang3.tuple.Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        dimensionEntries = null;
    }

    private record DimensionEntry(AirQualityLevel baseQuality, List<Pair<Integer, AirQualityLevel>> heights) {
    }
}

