/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.handler;

import com.mojang.datafixers.util.Pair;
import fuzs.thinair.advancements.AirProtectionSource;
import fuzs.thinair.advancements.AirSource;
import fuzs.thinair.advancements.ModAdvancementTriggers;
import fuzs.thinair.core.CommonAbstractions;
import fuzs.thinair.helper.AirHelper;
import fuzs.thinair.helper.AirQualityLevel;
import fuzs.thinair.init.ModRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;

public class TickAirChecker {
    public static void onLivingTick(LivingEntity entity) {
        Pair<AirQualityLevel, AirSource> o2Pair = AirHelper.getO2LevelFromLocation(entity.m_146892_(), entity.f_19853_);
        int deltaO2 = 0;
        AirProtectionSource protection = switch ((AirQualityLevel)((Object)o2Pair.getFirst())) {
            default -> throw new IncompatibleClassChangeError();
            case AirQualityLevel.GREEN -> {
                deltaO2 = 4;
                yield AirProtectionSource.NONE;
            }
            case AirQualityLevel.BLUE -> {
                deltaO2 = 0;
                yield AirProtectionSource.NONE;
            }
            case AirQualityLevel.YELLOW -> {
                AirProtectionSource prot = AirHelper.getProtectionFromYellow(entity);
                if (prot == AirProtectionSource.NONE) {
                    if (entity.f_19853_.m_46467_() % 4L == 0L) {
                        deltaO2 = -1;
                    }
                } else if (prot == AirProtectionSource.RESPIRATOR && !entity.f_19853_.f_46443_ && entity.f_19853_.m_46467_() % 300L == 0L) {
                    CommonAbstractions.INSTANCE.findEquippedItem(entity, (Item)ModRegistry.RESPIRATOR_ITEM.get()).ifPresent(stack -> {
                        ServerPlayer player;
                        stack.m_220157_(1, entity.m_217043_(), entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null);
                    });
                }
                yield prot;
            }
            case AirQualityLevel.RED -> {
                AirProtectionSource prot = AirHelper.getProtectionFromRed(entity);
                if (prot == AirProtectionSource.NONE) {
                    deltaO2 = -1;
                }
                yield prot;
            }
        };
        if (entity instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)entity;
            ModAdvancementTriggers.BREATHE_AIR.trigger(splayer, (AirQualityLevel)((Object)o2Pair.getFirst()), (AirSource)((Object)o2Pair.getSecond()), protection);
        }
        if (deltaO2 != 0) {
            int respirationLevel;
            boolean skipAirLossDueToRespiration = false;
            if (deltaO2 < 0 && (respirationLevel = EnchantmentHelper.m_44918_((LivingEntity)entity)) != 0 && entity.m_217043_().m_188503_(respirationLevel + 1) > 0) {
                skipAirLossDueToRespiration = true;
            }
            if (!skipAirLossDueToRespiration) {
                int newO2 = Math.min(entity.m_20146_() + deltaO2, entity.m_6062_());
                entity.m_20301_(newO2);
                if (newO2 <= -20) {
                    entity.m_20301_(newO2 + 20);
                    Vec3 vel = entity.m_20184_();
                    for (int i = 0; i < 8; ++i) {
                        RandomSource random = entity.f_19853_.m_213780_();
                        double dx = random.m_188500_() - random.m_188500_();
                        double dy = random.m_188500_() - random.m_188500_();
                        double dz = random.m_188500_() - random.m_188500_();
                        entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_() + dx, entity.m_20186_() + dy, entity.m_20189_() + dz, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                    }
                    entity.m_6469_(DamageSource.f_19312_, 2.0f);
                }
            }
        }
    }
}

