/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.helper;

import com.mojang.datafixers.util.Pair;
import fuzs.thinair.advancements.AirProtectionSource;
import fuzs.thinair.advancements.AirSource;
import fuzs.thinair.capability.AirBubblePositionsCapability;
import fuzs.thinair.capability.AirProtectionCapability;
import fuzs.thinair.config.CommonConfig;
import fuzs.thinair.core.CommonAbstractions;
import fuzs.thinair.handler.AirBubbleTracker;
import fuzs.thinair.helper.AirBubble;
import fuzs.thinair.helper.AirQualityLevel;
import fuzs.thinair.init.ModRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class AirHelper {
    public static Pair<AirQualityLevel, AirSource> getO2LevelFromLocation(Vec3 position, Level world) {
        if (AirHelper.isInFluid(position, world)) {
            return new Pair((Object)AirQualityLevel.RED, (Object)AirSource.FLUID);
        }
        Pair bestAirBubbleQuality = null;
        ChunkPos centerChunkPos = new ChunkPos(new BlockPos(position));
        int chunkRadius = 2;
        block0: for (int cdx = -chunkRadius; cdx <= chunkRadius; ++cdx) {
            for (int cdz = -chunkRadius; cdz <= chunkRadius; ++cdz) {
                Optional maybeCap;
                ChunkPos chunkpos = new ChunkPos(centerChunkPos.f_45578_ + cdx, centerChunkPos.f_45579_ + cdz);
                LevelChunk chunk = world.m_7726_().m_7131_(chunkpos.f_45578_, chunkpos.f_45579_);
                if (chunk == null || (maybeCap = ModRegistry.AIR_BUBBLE_POSITIONS_CAPABILITY.maybeGet((Object)chunk)).isEmpty()) continue;
                AirBubblePositionsCapability cap = (AirBubblePositionsCapability)maybeCap.get();
                for (BlockPos pos : cap.getEntries().keySet()) {
                    AirBubble entry = cap.getEntries().get(pos);
                    if (bestAirBubbleQuality != null && ((AirQualityLevel)((Object)bestAirBubbleQuality.getFirst())).bubbleBeats(entry.airQuality())) continue;
                    BlockState bs = world.m_8055_(pos);
                    double distSq = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).m_82557_(position);
                    if (!AirBubbleTracker.canProjectAirBubble(bs) || !(distSq < entry.radius() * entry.radius())) continue;
                    AirSource source = AirSource.OTHER;
                    if (bs.m_60713_(Blocks.f_50684_) || bs.m_60713_(Blocks.f_50084_) || bs.m_60713_(Blocks.f_50139_) || bs.m_60713_(Blocks.f_50140_)) {
                        source = AirSource.SOUL;
                    } else if (bs.m_60713_(Blocks.f_49991_)) {
                        source = AirSource.LAVA;
                    } else if (bs.m_60713_(Blocks.f_50142_)) {
                        source = AirSource.NETHER_PORTAL;
                    }
                    bestAirBubbleQuality = new Pair((Object)entry.airQuality(), (Object)source);
                    if (entry.airQuality() != AirQualityLevel.RED) continue;
                    break block0;
                }
            }
        }
        if (bestAirBubbleQuality != null) {
            return bestAirBubbleQuality;
        }
        ResourceLocation dim = world.m_46472_().m_135782_();
        AirQualityLevel quality = CommonConfig.getAirQualityAtLevelByDimension(dim, (int)Math.round(position.f_82480_));
        return new Pair((Object)quality, (Object)AirSource.DIMENSION);
    }

    public static boolean isInFluid(Vec3 position, Level world) {
        BlockState blockAtEyes = world.m_8055_(new BlockPos(position));
        return !blockAtEyes.m_60819_().m_76178_() && !blockAtEyes.m_60713_(Blocks.f_50628_);
    }

    public static AirProtectionSource getProtectionFromYellow(LivingEntity entity) {
        AirProtectionSource red = AirHelper.getProtectionFromRed(entity);
        if (red != AirProtectionSource.NONE) {
            return red;
        }
        if (CommonAbstractions.INSTANCE.findEquippedItem(entity, (Item)ModRegistry.RESPIRATOR_ITEM.get()).isPresent()) {
            return AirProtectionSource.RESPIRATOR;
        }
        return AirProtectionSource.NONE;
    }

    public static AirProtectionSource getProtectionFromRed(LivingEntity entity) {
        AirProtectionCapability cap;
        if (AirHelper.canAlwaysBreathe(entity)) {
            return AirProtectionSource.INHERENT;
        }
        if (MobEffectUtil.m_19588_((LivingEntity)entity)) {
            return AirProtectionSource.WATER_BREATHING;
        }
        Optional maybeCap = ModRegistry.AIR_PROTECTION_CAPABILITY.maybeGet((Object)entity);
        if (maybeCap.isPresent() && (cap = (AirProtectionCapability)maybeCap.get()).isProtected()) {
            return AirProtectionSource.BLADDER;
        }
        return AirProtectionSource.NONE;
    }

    public static boolean canAlwaysBreathe(LivingEntity entity) {
        block3: {
            block2: {
                if (entity.m_6040_()) break block2;
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (!player.m_150110_().f_35934_) break block3;
            }
            return true;
        }
        List alwaysOkEntities = (List)CommonConfig.alwaysBreathingEntities.get();
        return alwaysOkEntities.contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    }
}

