/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.world.level.block;

import fuzs.thinair.helper.AirHelper;
import fuzs.thinair.helper.AirQualityLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class SafetyLanternBlock
extends LanternBlock {
    public static final EnumProperty<AirQualityLevel> AIR_QUALITY = EnumProperty.m_61587_((String)"air_quality", AirQualityLevel.class);
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;

    public SafetyLanternBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AIR_QUALITY, (Comparable)((Object)AirQualityLevel.GREEN))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        super.m_7926_(definition);
        definition.m_61104_(new Property[]{AIR_QUALITY, LOCKED});
    }

    private static BlockState setAirQuality(Level world, BlockPos pos, BlockState template) {
        return (BlockState)template.m_61124_(AIR_QUALITY, (Comparable)((Object)((AirQualityLevel)((Object)AirHelper.getO2LevelFromLocation(Vec3.m_82512_((Vec3i)pos), world).getFirst()))));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockState bs = (BlockState)this.m_49966_().m_61124_((Property)f_153460_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        bs = SafetyLanternBlock.setAirQuality(ctx.m_43725_(), ctx.m_8083_(), bs);
        for (Direction direction : ctx.m_6232_()) {
            BlockState out;
            if (direction.m_122434_() != Direction.Axis.Y || !(out = (BlockState)bs.m_61124_((Property)f_153459_, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) continue;
            return out;
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_186464_(pPos, (Block)this, 20, TickPriority.NORMAL);
    }

    public InteractionResult m_6227_(BlockState bs, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHit) {
        ItemStack itemUsed = player.m_21120_(hand);
        AirQualityLevel lockedAirQuality = null;
        AirQualityLevel presentLockedAirQuality = null;
        boolean strippedDye = false;
        if (((Boolean)bs.m_61143_((Property)LOCKED)).booleanValue()) {
            presentLockedAirQuality = (AirQualityLevel)((Object)bs.m_61143_(AIR_QUALITY));
        }
        if (itemUsed.m_150930_(Items.f_42496_) && presentLockedAirQuality != AirQualityLevel.GREEN) {
            lockedAirQuality = AirQualityLevel.GREEN;
        } else if (itemUsed.m_150930_(Items.f_42494_) && presentLockedAirQuality != AirQualityLevel.BLUE) {
            lockedAirQuality = AirQualityLevel.BLUE;
        } else if (itemUsed.m_150930_(Items.f_42539_) && presentLockedAirQuality != AirQualityLevel.YELLOW) {
            lockedAirQuality = AirQualityLevel.YELLOW;
        } else if (itemUsed.m_150930_(Items.f_42497_) && presentLockedAirQuality != AirQualityLevel.RED) {
            lockedAirQuality = AirQualityLevel.RED;
        } else if (itemUsed.m_41720_() instanceof AxeItem && ((Boolean)bs.m_61143_((Property)LOCKED)).booleanValue()) {
            strippedDye = true;
        }
        boolean didAnything = false;
        BlockState newBs = bs;
        if (lockedAirQuality != null) {
            newBs = (BlockState)((BlockState)newBs.m_61124_(AIR_QUALITY, (Comparable)((Object)lockedAirQuality))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(true));
            world.m_5898_(player, 3003, pos, 0);
            if (!player.m_150110_().f_35937_) {
                itemUsed.m_41774_(1);
            }
            didAnything = true;
        } else if (strippedDye) {
            world.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3005, pos, 0);
            itemUsed.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            player.m_6674_(hand);
            newBs = (BlockState)newBs.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false));
            newBs = SafetyLanternBlock.setAirQuality(world, pos, newBs);
            didAnything = true;
        }
        world.m_46597_(pos, newBs);
        if (didAnything) {
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_186464_(pPos, (Block)this, 20, TickPriority.NORMAL);
        if (!((Boolean)pState.m_61143_((Property)LOCKED)).booleanValue()) {
            pLevel.m_46597_(pPos, SafetyLanternBlock.setAirQuality((Level)pLevel, pPos, pState));
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return ((AirQualityLevel)((Object)pState.m_61143_(AIR_QUALITY))).getOutputSignal();
    }
}

