/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import fuzs.puzzleslib.network.Message;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.mixin.client.accessor.ButtonAccessor;
import fuzs.tradingpost.mixin.client.accessor.MerchantScreenAccessor;
import fuzs.tradingpost.mixin.client.accessor.TradeOfferButtonAccessor;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class TradingPostScreen
extends MerchantScreen {
    public static final ResourceLocation MAGNIFYING_GLASS_LOCATION = new ResourceLocation("tradingpost", "item/magnifying_glass");
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("textures/gui/container/villager2.png");
    private static final ResourceLocation CREATIVE_INVENTORY_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tab_item_search.png");
    private static final Component DEPRECATED_TOOLTIP = Component.m_237115_((String)"merchant.deprecated");
    private static final Component MERCHANT_GONE = Component.m_237115_((String)"trading_post.trader_gone");
    private Button[] tradeOfferButtons = new Button[7];
    private EditBox searchBox;
    private boolean ignoreTextInput;

    public TradingPostScreen(MerchantMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        for (Button tradeOfferButton : this.tradeOfferButtons = this.getTradeOfferButtons(ClientCoreServices.SCREENS.getRenderableButtons((Screen)this))) {
            ((ButtonAccessor)tradeOfferButton).setOnPress(button -> {
                MerchantScreenAccessor accessor = (MerchantScreenAccessor)((Object)this);
                int shopItem = ((TradeOfferButtonAccessor)button).getIndex() + accessor.getScrollOff();
                MerchantOffers offers = this.getMenu().m_40075_();
                accessor.setShopItem(shopItem);
                this.getMenu().m_40063_(shopItem);
                this.getMenu().getTraders().setActiveOffer((MerchantOffer)offers.get(shopItem));
                this.getMenu().m_40072_(shopItem);
                this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundSelectTradePacket(offers instanceof TradingPostOffers ? ((TradingPostOffers)offers).getOrigShopItem(shopItem) : shopItem));
            });
        }
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 13, this.f_97736_ + 6, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                    TradingPostScreen.this.refreshSearchResults();
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    private Button[] getTradeOfferButtons(List<Widget> buttons) {
        Button[] tradeOfferButtons = (Button[])buttons.stream().filter(button -> button instanceof TradeOfferButtonAccessor).map(button -> (Button)button).toArray(Button[]::new);
        if (tradeOfferButtons.length != 7) {
            TradingPost.LOGGER.warn("Unable to find enough tradeOfferButtons");
        }
        return tradeOfferButtons;
    }

    public void m_6574_(Minecraft mc, int newWidth, int newHeight) {
        String lastSearch = this.searchBox.m_94155_();
        super.m_6574_(mc, newWidth, newHeight);
        this.searchBox.m_94144_(lastSearch);
        if (!this.searchBox.m_94155_().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        Component title = this.getMenu().getTraders().getDisplayName();
        if (title != null) {
            int traderLevel = ((MerchantMenu)this.f_97732_).m_40071_();
            if (traderLevel > 0 && traderLevel <= 5 && ((MerchantMenu)this.f_97732_).m_40076_()) {
                title = title.m_6881_().m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)("merchant.level." + traderLevel)));
            }
        } else {
            title = this.f_96539_;
        }
        this.f_96547_.m_92889_(matrixStack, title, (float)(49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTime) {
        MerchantOffers merchantoffers = this.getMenu().m_40075_();
        this.setButtonsActive(merchantoffers);
        int scrollOff = ((MerchantScreenAccessor)((Object)this)).getScrollOff();
        Slot hoveredSlot = this.f_97734_;
        this.lock(true, merchantoffers.size(), null);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTime);
        this.lock(false, scrollOff, hoveredSlot);
        if (!merchantoffers.isEmpty()) {
            MerchantOffer merchantoffer;
            int shopItem = ((MerchantScreenAccessor)((Object)this)).getShopItem();
            if (shopItem >= 0 && shopItem < merchantoffers.size() && (merchantoffer = (MerchantOffer)merchantoffers.get(shopItem)).m_45380_()) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)VILLAGER_LOCATION);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TradingPostScreen.m_93143_((PoseStack)matrixStack, (int)(this.f_97735_ + 83 + 99), (int)(this.f_97736_ + 35), (int)this.m_93252_(), (float)311.0f, (float)0.0f, (int)28, (int)21, (int)512, (int)256);
            }
            int width = (this.f_96543_ - this.f_97726_) / 2;
            int height = (this.f_96544_ - this.f_97727_) / 2;
            int posX = width + 5;
            int posY = height + 16 + 2;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VILLAGER_LOCATION);
            ((MerchantScreenAccessor)((Object)this)).callRenderScroller(matrixStack, width, height, merchantoffers);
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer2 = (MerchantOffer)merchantoffers.get(i);
                ((MerchantScreenAccessor)((Object)this)).callRenderButtonArrows(matrixStack, merchantoffer2, width, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    GuiComponent.m_93172_((PoseStack)matrixStack, (int)posX, (int)posY, (int)(posX + 88), (int)(posY + 20), (int)0x30FF0000);
                }
                ItemStack itemstack = merchantoffer2.m_45352_();
                ItemStack itemstack1 = merchantoffer2.m_45358_();
                ItemStack itemstack2 = merchantoffer2.m_45364_();
                ItemStack itemstack3 = merchantoffer2.m_45368_();
                this.f_96542_.f_115093_ = 100.0f;
                this.f_96542_.m_115218_(itemstack1, posX + 5, posY + 1);
                if (!itemstack2.m_41619_()) {
                    this.f_96542_.m_115218_(itemstack2, posX + 35, posY + 1);
                }
                this.f_96542_.m_115218_(itemstack3, posX + 68, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    RenderSystem.m_69456_((int)516);
                    GuiComponent.m_93172_((PoseStack)matrixStack, (int)posX, (int)posY, (int)(posX + 88), (int)(posY + 20), (int)0x30FFFFFF);
                    RenderSystem.m_69456_((int)515);
                }
                if (itemstack.m_41613_() == itemstack1.m_41613_()) {
                    this.f_96542_.m_115169_(this.f_96547_, itemstack1, posX + 5, posY + 1);
                } else {
                    this.f_96542_.m_115174_(this.f_96547_, itemstack, posX + 5, posY + 1, itemstack.m_41613_() == 1 ? "1" : null);
                    this.f_96542_.m_115174_(this.f_96547_, itemstack1, posX + 5 + 14, posY + 1, itemstack1.m_41613_() == 1 ? "1" : null);
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)VILLAGER_LOCATION);
                    this.m_93250_(this.m_93252_() + 300);
                    TradingPostScreen.m_93143_((PoseStack)matrixStack, (int)(posX + 5 + 7), (int)(posY + 1 + 12), (int)this.m_93252_(), (float)0.0f, (float)176.0f, (int)9, (int)2, (int)512, (int)256);
                    this.m_93250_(this.m_93252_() - 300);
                }
                if (!itemstack2.m_41619_()) {
                    this.f_96542_.m_115169_(this.f_96547_, itemstack2, posX + 35, posY + 1);
                }
                this.f_96542_.m_115169_(this.f_96547_, itemstack3, posX + 68, posY + 1);
                this.f_96542_.f_115093_ = 0.0f;
                posY += 20;
            }
            MerchantOffer activeOffer = (MerchantOffer)merchantoffers.get(shopItem);
            if (this.getMenu().m_40076_()) {
                ((MerchantScreenAccessor)((Object)this)).callRenderProgressBar(matrixStack, width, height, activeOffer);
            }
            if (activeOffer.m_45380_() && this.m_6774_(186, 35, 22, 21, mouseX, mouseY) && this.getMenu().m_40074_()) {
                this.m_96602_(matrixStack, DEPRECATED_TOOLTIP, mouseX, mouseY);
            }
            posY = height + 16 + 2;
            int merchantoffersSize2 = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize2; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer3 = (MerchantOffer)merchantoffers.get(i);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer3) && this.m_6774_(posX, posY, 88, 19, mouseX + this.f_97735_, mouseY + this.f_97736_)) {
                    this.m_96602_(matrixStack, MERCHANT_GONE, mouseX, mouseY);
                }
                posY += 20;
            }
            RenderSystem.m_69482_();
        }
        Button[] offerButtons = this.tradeOfferButtons;
        int offerButtonsLength = offerButtons.length;
        for (int i = 0; i < offerButtonsLength; ++i) {
            Button button = offerButtons[i];
            if (button.f_93623_ && button.m_198029_()) {
                button.m_7428_(matrixStack, mouseX, mouseY);
            }
            button.f_93624_ = i < this.getMenu().m_40075_().size();
        }
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    private void setButtonsActive(MerchantOffers merchantoffers) {
        if (!merchantoffers.isEmpty()) {
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                int scrollOff = ((MerchantScreenAccessor)((Object)this)).getScrollOff();
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer offer = (MerchantOffer)merchantoffers.get(i);
                this.tradeOfferButtons[i - scrollOff].f_93623_ = this.getMenu().getTraders().checkOffer(offer);
            }
        }
    }

    private void lock(boolean lockOffers, int newScrollOff, Slot newHoveredSlot) {
        this.getMenu().lockOffers(lockOffers);
        ((MerchantScreenAccessor)((Object)this)).setScrollOff(newScrollOff);
        this.f_97734_ = newHoveredSlot;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.renderSearchBox(matrixStack, partialTicks, mouseX, mouseY);
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(MAGNIFYING_GLASS_LOCATION);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        TradingPostScreen.m_93200_((PoseStack)matrixStack, (int)this.f_97735_, (int)(this.f_97736_ + 4), (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VILLAGER_LOCATION);
    }

    private void renderSearchBox(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CREATIVE_INVENTORY_LOCATION);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        TradingPostScreen.m_93143_((PoseStack)matrixStack, (int)(i + 11), (int)(j + 4), (int)this.m_93252_(), (float)80.0f, (float)4.0f, (int)90, (int)12, (int)256, (int)256);
        this.searchBox.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseKey) {
        if (this.searchBox.m_6375_(mouseX, mouseY, mouseKey)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseKey);
    }

    protected void m_181908_() {
        this.searchBox.m_94120_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifierKeys) {
        this.ignoreTextInput = false;
        String lastSearch = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(keyCode, scanCode, modifierKeys)) {
            if (!Objects.equals(this.searchBox.m_94155_(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && !this.searchBox.m_93696_()) {
            this.ignoreTextInput = true;
            this.searchBox.m_94178_(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifierKeys);
    }

    public boolean m_5534_(char typedChar, int modifierKeys) {
        String lastSearch = this.searchBox.m_94155_();
        if (!this.ignoreTextInput && this.searchBox.m_5534_(typedChar, modifierKeys)) {
            if (!Objects.equals(this.searchBox.m_94155_(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        return super.m_5534_(typedChar, modifierKeys);
    }

    public void refreshSearchResults() {
        MerchantOffers merchantOffers = this.getMenu().m_40075_();
        if (!(merchantOffers instanceof TradingPostOffers)) {
            return;
        }
        TradingPostOffers offers = (TradingPostOffers)merchantOffers;
        String query = this.searchBox.m_94155_();
        if (query.isEmpty()) {
            offers.clearFilter();
        } else {
            SearchTree isearchtree = this.f_96541_.m_231372_(TradingPostClient.OFFER_SEARCH_TREE);
            offers.setFilter(isearchtree.m_6293_(query.toLowerCase(Locale.ROOT)));
        }
        ((MerchantScreenAccessor)((Object)this)).setScrollOff(0);
        ((MerchantScreenAccessor)((Object)this)).setShopItem(0);
        this.getMenu().m_40063_(-1);
        this.getMenu().getTraders().setActiveOffer(null);
        this.getMenu().clearPaymentSlots();
        TradingPost.NETWORK.sendToServer((Message)new C2SClearSlotsMessage());
    }

    public TradingPostMenu getMenu() {
        return (TradingPostMenu)super.m_6262_();
    }
}

