/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.villagersplus.client.renderer;

import com.finallion.villagersplus.blockentities.OceanographerTableBlockEntity;
import com.finallion.villagersplus.blocks.OceanographerTableBlock;
import com.finallion.villagersplus.init.ModTags;
import com.finallion.villagersplus.util.DuckBucketable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class OceanographerTableBlockEntityRenderer
implements BlockEntityRenderer<OceanographerTableBlockEntity> {
    private final BlockRenderDispatcher manager;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final Minecraft minecraft;
    private float[] xOffset = new float[]{0.06f, 1.5f, 1.3f, 0.1f};
    private final float[] yOffsetNorth = new float[]{0.45f, 0.75f, 0.3f, 0.45f};
    private final float[] yOffsetSouth = new float[]{0.75f, 0.45f, 0.45f, 0.3f};
    private final float[] yOffsetEast = new float[]{0.45f, 0.3f, 0.45f, 0.75f};
    private final float[] yOffsetWest = new float[]{0.3f, 0.45f, 0.75f, 0.45f};
    private float[] zOffset = new float[]{0.06f, 1.5f, 0.3f, 1.45f};
    private float[] xOffsetFan = new float[]{0.2f, 1.25f, 1.2f, 0.2f};
    private float[] zOffsetFan = new float[]{0.17f, 1.25f, 0.3f, 1.2f};

    public OceanographerTableBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.minecraft = Minecraft.m_91087_();
        this.manager = ctx.m_173584_();
        this.entityRenderDispatcher = ctx.m_234446_();
    }

    public void render(OceanographerTableBlockEntity blockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j) {
        BlockState blockState = blockEntity.m_58900_();
        BlockPos pos = blockEntity.m_58899_();
        Level world = blockEntity.m_58904_();
        NonNullList<ItemStack> defaultedList = blockEntity.getItems();
        if (blockState.m_60734_() instanceof OceanographerTableBlock) {
            Item offset;
            float rotation = 0.0f;
            float[] yOffset = new float[4];
            switch ((Direction)blockState.m_61143_((Property)OceanographerTableBlock.FACING)) {
                case EAST: {
                    rotation = 90.0f;
                    yOffset = this.yOffsetEast;
                    this.xOffset = new float[]{0.06f, 1.5f, 1.3f, 0.015f};
                    this.zOffset = new float[]{0.06f, 1.5f, 0.3f, 1.5f};
                    this.xOffsetFan = new float[]{0.2f, 1.25f, 1.2f, 0.115f};
                    this.zOffsetFan = new float[]{0.17f, 1.25f, 0.3f, 1.3f};
                    break;
                }
                case WEST: {
                    rotation = 270.0f;
                    yOffset = this.yOffsetWest;
                    this.xOffset = new float[]{0.06f, 1.5f, 1.55f, 0.1f};
                    this.zOffset = new float[]{0.06f, 1.5f, 0.15f, 1.45f};
                    this.xOffsetFan = new float[]{0.2f, 1.25f, 1.45f, 0.2f};
                    this.zOffsetFan = new float[]{0.17f, 1.25f, 0.15f, 1.2f};
                    break;
                }
                case NORTH: {
                    rotation = 180.0f;
                    yOffset = this.yOffsetNorth;
                    break;
                }
                case SOUTH: {
                    rotation = 0.0f;
                    yOffset = this.yOffsetSouth;
                }
            }
            for (int it = 0; it < 4; ++it) {
                matrixStack.m_85836_();
                Block coral = Block.m_49814_((Item)((ItemStack)defaultedList.get(it)).m_41720_());
                offset = coral.m_49966_().m_60824_((BlockGetter)world, pos);
                matrixStack.m_85841_(0.4f, 0.4f, 0.4f);
                if (coral instanceof CoralFanBlock) {
                    matrixStack.m_85837_(-offset.f_82479_ + (double)this.xOffsetFan[it], -offset.f_82480_ + (double)yOffset[it], -offset.f_82481_ + (double)this.zOffsetFan[it]);
                } else {
                    matrixStack.m_85837_(-offset.f_82479_ + (double)this.xOffset[it], -offset.f_82480_ + (double)yOffset[it], -offset.f_82481_ + (double)this.zOffset[it]);
                }
                this.renderCoral(coral, world, pos, matrixStack, vertexConsumerProvider, j);
                matrixStack.m_85849_();
            }
            ItemStack itemStack = (ItemStack)defaultedList.get(4);
            offset = itemStack.m_41720_();
            if (offset instanceof MobBucketItem) {
                MobBucketItem bucketItem = (MobBucketItem)offset;
                Entity fish = ((DuckBucketable)bucketItem).getEntityType().m_20615_(world);
                if (fish != null && itemStack.m_41783_() != null) {
                    fish.m_20258_(itemStack.m_41784_());
                    if (fish instanceof TropicalFish && itemStack.m_41783_().m_128441_("BucketVariantTag")) {
                        int id = itemStack.m_41783_().m_128451_("BucketVariantTag");
                        ((TropicalFish)fish).m_30056_(id);
                    }
                }
                matrixStack.m_85836_();
                if (fish != null) {
                    long time = world.m_46467_();
                    float g = 0.53125f;
                    float h = Math.max(fish.m_20205_(), fish.m_20206_());
                    if ((double)h > 1.0) {
                        g /= h;
                    }
                    float k = Mth.m_14031_((float)((float)time * 0.1f)) / 2.0f + 0.5f;
                    k += k * k;
                    matrixStack.m_85837_(0.5, (double)(0.5f + k * 0.05f), 0.5);
                    matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
                    Vector3f vec3f = new Vector3f(0.5f, 1.0f, 0.5f);
                    vec3f.m_122278_();
                    matrixStack.m_85845_(vec3f.m_122240_(h));
                    if (itemStack.m_204117_(ModTags.ROTATIONAL_BUCKET_ENTITIES)) {
                        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    }
                    matrixStack.m_85841_(g, g, g);
                    if (!(fish instanceof Axolotl)) {
                        f = (float)time / 4.0f;
                    } else {
                        matrixStack.m_85837_(0.0, (double)-0.2f, 0.0);
                        matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
                        f = 0.0f;
                    }
                    this.entityRenderDispatcher.m_114384_(fish, 0.0, 0.0, 0.0, 0.0f, f, matrixStack, vertexConsumerProvider, i);
                }
                matrixStack.m_85849_();
            }
        }
    }

    private void renderCoral(Block coral, Level world, BlockPos pos, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int overlay) {
        this.manager.m_110937_().tesselateBlock((BlockAndTintGetter)world, this.manager.m_110910_(coral.m_49966_()), coral.m_49966_(), pos, matrixStack, vertexConsumerProvider.m_6299_(RenderType.m_110457_()), false, RandomSource.m_216327_(), coral.m_49966_().m_60726_(pos), overlay, ModelData.EMPTY, RenderType.m_110457_());
    }
}

