/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;

public class ClientEventsForge
extends ClientEvents {
    public ClientEventsForge(IXaeroMinimap modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setNewScreen(gui);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGuiEvent.Pre event) {
        XaeroMinimapCore.beforeIngameGuiRender(event.getPartialTick());
        this.handleRenderGameOverlayEventPre(event.getPoseStack(), event.getPartialTick());
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPost(RenderGuiEvent.Post event) {
        this.handleRenderGameOverlayEventPost();
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type() && this.handleRenderStatusEffectOverlay(event.getPoseStack())) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && this.handleRenderCrosshairOverlay(event.getPoseStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type()) {
            XaeroMinimapCore.onPotionEffectsRender();
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChatEvent(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(e.getPlayerChatMessage().m_241067_().f_240864_());
        if (playerInfo != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, playerInfo)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleRenderSolidBlocks(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
            XaeroMinimapCore.onWorldModelViewMatrix(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.worldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleClientTickStart();
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handlePlayerTickStart(event.player);
        }
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleRenderTickStart();
        }
    }
}

