/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.tracker;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerIconRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElement;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementCollector;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementReader;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.common.minimap.render.MinimapRendererHelper;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(Player player, PlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).m_108560_() : info.m_105337_();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.m_118627_((UUID)player.m_20148_());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
        if (modMain.getSupportMods().worldmap()) {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = modMain.getSupportMods().worldmapSupport.getMapDimension();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getLastPlayerDimDiv();
        } else {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = Minecraft.m_91087_().f_91073_.m_46472_();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = 1.0;
        }
    }

    @Override
    public void postRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.m_109911_();
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, PlayerTrackerMinimapElement<?> e, double partialX, double partialY, boolean cave, float partialTicks) {
        if (!outOfBounds && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        PlayerInfo info = mc.m_91403_().m_104949_(e.getPlayerId());
        if (info != null) {
            Player clientPlayer = mc.f_91073_.m_46003_(e.getPlayerId());
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, optionalDepth);
            matrixStack.m_85841_(optionalScale, optionalScale, 1.0f);
            helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_85861_(), ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85837_(0.0, 0.0, 0.01);
            this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer, helper, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info));
            matrixStack.m_85849_();
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.modMain.getSettings().displayTrackedPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext>(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

