/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.dimension.renderer.StarInformation;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.common.level.LevelSeed;
import earth.terrarium.ad_astra.mixin.client.LevelRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkyUtil {
    public static float getScale() {
        Minecraft minecraft = Minecraft.m_91087_();
        float distance = (float)(-3000.0 + minecraft.f_91074_.m_20186_() * 4.5);
        float scale = 100.0f * (0.2f - distance / 10000.0f);
        return Math.max(scale, 0.5f);
    }

    public static void preRender(ClientLevel level, LevelRenderer levelRenderer, Camera camera, Matrix4f projectionMatrix, BufferBuilder bufferBuilder, PlanetSkyRenderer.SunsetColour colourType, int sunsetAngle, PoseStack poseStack, float tickDelta) {
        RenderSystem.m_69472_();
        Vec3 vec3d = level.m_171660_(camera.m_90583_(), tickDelta);
        float f = (float)vec3d.m_7096_();
        float g = (float)vec3d.m_7098_();
        float h = (float)vec3d.m_7094_();
        FogRenderer.m_109036_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)g, (float)h, (float)1.0f);
        VertexBuffer skyBuffer = ((LevelRendererAccessor)levelRenderer).getSkyBuffer();
        skyBuffer.m_85921_();
        skyBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, RenderSystem.m_157196_());
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        SkyUtil.renderColouring(colourType, bufferBuilder, poseStack, level, tickDelta, level.m_46942_(tickDelta), sunsetAngle);
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void postRender(GameRenderer renderer, ClientLevel level, float tickDelta) {
        Vec3 vec3d = level.m_171660_(renderer.m_109153_().m_90583_(), tickDelta);
        float f = (float)vec3d.m_7096_();
        float g = (float)vec3d.m_7098_();
        float h = (float)vec3d.m_7094_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(h * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)f, (float)g, (float)h, (float)1.0f);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
    }

    public static boolean isSubmerged(Camera camera) {
        FogType cameraSubmersionType = camera.m_167685_();
        if (cameraSubmersionType.equals((Object)FogType.POWDER_SNOW) || cameraSubmersionType.equals((Object)FogType.LAVA)) {
            return true;
        }
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21023_(MobEffects.f_19610_) || livingEntity.m_21023_(MobEffects.f_216964_);
        }
        return false;
    }

    public static void startRendering(PoseStack poseStack, Vector3f rotation) {
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation.m_122260_()));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rotation.m_122269_()));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(rotation.m_122239_()));
    }

    private static void endRendering(PoseStack poseStack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    public static void render(PoseStack poseStack, BufferBuilder bufferBuilder, ResourceLocation texture, Color colour, Vector3f rotation, float scale, boolean blending) {
        SkyUtil.startRendering(poseStack, rotation);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)((float)colour.getIntRed() / 255.0f), (float)((float)colour.getIntGreen() / 255.0f), (float)((float)colour.getIntBlue() / 255.0f), (float)1.0f);
        if (blending) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f positionMatrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_85982_(positionMatrix, -scale, 100.0f, -scale).m_7421_(1.0f, 0.0f).m_6122_(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).m_5752_();
        bufferBuilder.m_85982_(positionMatrix, scale, 100.0f, -scale).m_7421_(0.0f, 0.0f).m_6122_(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).m_5752_();
        bufferBuilder.m_85982_(positionMatrix, scale, 100.0f, scale).m_7421_(0.0f, 1.0f).m_6122_(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).m_5752_();
        bufferBuilder.m_85982_(positionMatrix, -scale, 100.0f, scale).m_7421_(1.0f, 1.0f).m_6122_(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        SkyUtil.endRendering(poseStack);
    }

    public static BufferBuilder.RenderedBuffer renderStars(BufferBuilder buffer, int stars, boolean colouredStars) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        StarInformation info = (StarInformation)StarInformation.STAR_CACHE.apply((Object)LevelSeed.getSeed(), (Object)stars);
        for (int i = 0; i < stars; ++i) {
            Vector3f vec3f = info.getParam1(i);
            float d = vec3f.m_122239_();
            float e = vec3f.m_122260_();
            float f = vec3f.m_122269_();
            float g = info.getMultiplier(i);
            float h = d * d + e * e + f * f;
            if (h >= 1.0f || h <= 0.01f) continue;
            h = 1.0f / Mth.m_14116_((float)h);
            float j = (d *= h) * 100.0f;
            float k = (e *= h) * 100.0f;
            float l = (f *= h) * 100.0f;
            float m = (float)Math.atan2(d, f);
            float n = Mth.m_14031_((float)m);
            float o = Mth.m_14089_((float)m);
            float p = (float)Math.atan2(Mth.m_14116_((float)(d * d + f * f)), e);
            float q = Mth.m_14031_((float)p);
            float r = Mth.m_14089_((float)p);
            float s = info.getRandomPi(i);
            float t = Mth.m_14031_((float)s);
            float u = Mth.m_14089_((float)s);
            for (int v = 0; v < 4; ++v) {
                float x = (float)((v & 2) - 1) * g;
                float y = (float)((v + 1 & 2) - 1) * g;
                float aa = x * u - y * t;
                float ac = y * u + x * t;
                float ae = aa * -r;
                Color colour = info.getColour(i, v, colouredStars);
                buffer.m_5483_((double)(j + ae * n - ac * o), (double)(k + aa * q), (double)(l + ac * n + ae * o)).m_6122_(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), colour.getIntAlpha()).m_5752_();
            }
        }
        return buffer.m_231175_();
    }

    public static float[] getMarsColour(float skyAngle) {
        float[] colours = new float[4];
        float cosine = Mth.m_14089_((float)(skyAngle * ((float)Math.PI * 2))) - 0.0f;
        if (cosine >= -0.4f && cosine <= 0.4f) {
            float c = (cosine + 0.0f) / 0.4f * 0.5f + 0.5f;
            float sine = 1.0f - (1.0f - Mth.m_14031_((float)(c * (float)Math.PI))) * 0.99f;
            sine *= sine;
            colours[0] = c * 0.3f;
            colours[1] = c * c * 0.6f + 0.55f;
            colours[2] = c * c * 0.0f + 0.8f;
            colours[3] = sine;
            return colours;
        }
        return null;
    }

    public static void renderColouring(PlanetSkyRenderer.SunsetColour type, BufferBuilder bufferBuilder, PoseStack poseStack, ClientLevel level, float tickDelta, float timeOfDay, int sunsetAngle) {
        float[] fogColours;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VANILLA: {
                float[] fArray = level.m_104583_().m_7518_(timeOfDay, tickDelta);
                break;
            }
            case MARS: {
                float[] fArray = fogColours = SkyUtil.getMarsColour(timeOfDay);
            }
        }
        if (fogColours != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            float sine = Mth.m_14031_((float)level.m_46490_(tickDelta)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(sine));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(fogColours[0], fogColours[1], fogColours[2], fogColours[3]).m_5752_();
            for (int i = 0; i <= 16; ++i) {
                float o = (float)i * ((float)Math.PI * 2) / 16.0f;
                float cosine = Mth.m_14089_((float)o);
                bufferBuilder.m_85982_(matrix4f, Mth.m_14031_((float)o) * 120.0f, cosine * 120.0f, -cosine * 40.0f * fogColours[3]).m_85950_(fogColours[0], fogColours[1], fogColours[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStack.m_85849_();
        }
    }
}

