/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.renderer;

import com.infamous.all_bark_all_bite.client.ABABModelLayers;
import com.infamous.all_bark_all_bite.client.compat.RWCompatClient;
import com.infamous.all_bark_all_bite.client.renderer.model.ABABWolfModel;
import com.infamous.all_bark_all_bite.client.renderer.model.layer.ABABWolfCollarLayer;
import com.infamous.all_bark_all_bite.client.renderer.model.layer.ItemInMouthLayer;
import com.infamous.all_bark_all_bite.client.renderer.model.layer.WolfSleepingLayer;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Wolf;

public class ABABWolfRenderer
extends MobRenderer<Wolf, ABABWolfModel<Wolf>> {
    private static final float DEFAULT_SHADOW_RADIUS = 0.5f;
    private static final ResourceLocation WOLF_LOCATION = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation WOLF_TAME_LOCATION = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation WOLF_ANGRY_LOCATION = new ResourceLocation("textures/entity/wolf/wolf_angry.png");

    public ABABWolfRenderer(EntityRendererProvider.Context context) {
        super(context, new ABABWolfModel(context.m_174023_(ABABModelLayers.WOLF)), 0.5f);
        this.m_115326_(new WolfSleepingLayer((RenderLayerParent<Wolf, ABABWolfModel<Wolf>>)this));
        this.m_115326_(new ABABWolfCollarLayer(this));
        this.m_115326_(new ItemInMouthLayer(this, context.m_234598_()));
        if (CompatUtil.isRWLoaded()) {
            this.m_115326_(RWCompatClient.getRWArmorLayer((RenderLayerParent<Wolf, ABABWolfModel<Wolf>>)this, context));
        }
    }

    public void render(Wolf wolf, float lerpYRot, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (wolf.m_30426_()) {
            float wetShade = wolf.m_30446_(partialTicks);
            ((ABABWolfModel)this.f_115290_).m_170501_(wetShade, wetShade, wetShade);
        }
        super.m_7392_((Mob)wolf, lerpYRot, partialTicks, poseStack, bufferSource, packedLight);
        if (wolf.m_30426_()) {
            ((ABABWolfModel)this.f_115290_).m_170501_(1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(Wolf wolf) {
        if (wolf.m_5803_()) {
            return WOLF_LOCATION;
        }
        if (wolf.m_21824_()) {
            return WOLF_TAME_LOCATION;
        }
        return wolf.m_21660_() ? WOLF_ANGRY_LOCATION : WOLF_LOCATION;
    }

    protected void scale(Wolf wolf, PoseStack poseStack, float partialTick) {
        float scaleFactor = ((Double)ABABConfig.wolfRenderSizeScale.get()).floatValue() * ((Double)ABABConfig.wolfHitboxSizeScale.get()).floatValue();
        if (wolf.m_6162_()) {
            scaleFactor *= 0.5f;
            this.f_114477_ = 0.25f;
        } else {
            this.f_114477_ = 0.5f;
        }
        poseStack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
    }
}

