/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.renderer.model;

import com.infamous.all_bark_all_bite.client.renderer.model.animation.WolfAnimation;
import com.infamous.all_bark_all_bite.common.entity.AnimationControllerAccess;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAnimationController;
import com.infamous.all_bark_all_bite.mixin.WolfAccessor;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.Wolf;

public class ABABWolfModel<T extends Wolf>
extends ColorableHierarchicalModel<T>
implements HeadedModel {
    public static final String HEAD = "head";
    public static final String BODY = "body";
    public static final String UPPER_BODY = "upper_body";
    public static final String RIGHT_HIND_LEG = "right_hind_leg";
    public static final String LEFT_HIND_LEG = "left_hind_leg";
    public static final String RIGHT_FRONT_LEG = "right_front_leg";
    public static final String LEFT_FRONT_LEG = "left_front_leg";
    public static final String TAIL = "tail";
    private static final float IDLE_SLEEP_ANIMATION_SPEED = 0.5f;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private float partialTicks;

    public ABABWolfModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_(HEAD);
        this.body = root.m_171324_(BODY);
        this.upperBody = this.body.m_171324_(UPPER_BODY);
        this.rightHindLeg = root.m_171324_(RIGHT_HIND_LEG);
        this.leftHindLeg = root.m_171324_(LEFT_HIND_LEG);
        this.rightFrontLeg = root.m_171324_(RIGHT_FRONT_LEG);
        this.leftFrontLeg = root.m_171324_(LEFT_FRONT_LEG);
        this.tail = root.m_171324_(TAIL);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition head = root.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 14).m_171488_(1.0f, -5.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 14).m_171488_(-3.0f, -5.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-1.5f, -0.02f, -6.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-6.0f));
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)2.0f));
        PartDefinition body_rotation_r1 = body.m_171599_("body_rotation_r1", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -0.5f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody = body.m_171599_(UPPER_BODY, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition mane_rotation_r1 = upperBody.m_171599_("mane_rotation_r1", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-4.0f, -8.5f, -3.0f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = root.m_171599_(RIGHT_HIND_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)7.0f));
        PartDefinition leg2 = root.m_171599_(LEFT_HIND_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)16.0f, (float)7.0f));
        PartDefinition leg3 = root.m_171599_(RIGHT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition leg4 = root.m_171599_(LEFT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = root.m_171599_(TAIL, CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void prepareMobModel(T wolf, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public void setupAnim(T wolf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        AnimationControllerAccess aca = AnimationControllerAccess.cast(wolf);
        SharedWolfAnimationController animationController = (SharedWolfAnimationController)aca.getAnimationController();
        this.m_233381_(animationController.attackAnimationState, WolfAnimation.ATTACK, ageInTicks);
        this.m_233381_(animationController.babyAnimationState, WolfAnimation.BABY, ageInTicks);
        this.m_233381_(animationController.crouchAnimationState, WolfAnimation.CROUCH, ageInTicks);
        this.m_233381_(animationController.idleAnimationState, WolfAnimation.IDLE, ageInTicks);
        this.m_233381_(animationController.idleSitAnimationState, WolfAnimation.IDLE_SIT, ageInTicks);
        this.m_233385_(animationController.idleSleepAnimationState, WolfAnimation.IDLE_SLEEP, ageInTicks, 0.5f);
        this.m_233381_(animationController.jumpAnimationState, WolfAnimation.JUMP, ageInTicks);
        this.m_233381_(animationController.leapAnimationState, WolfAnimation.LEAP, ageInTicks);
        this.m_233381_(animationController.sitAnimationState, WolfAnimation.SIT, ageInTicks);
        this.m_233381_(animationController.sleepAnimationState, WolfAnimation.SLEEP, ageInTicks);
        this.m_233381_(animationController.sprintAnimationState, WolfAnimation.SPRINT, ageInTicks);
        this.m_233381_(animationController.walkAnimationState, WolfAnimation.WALK, ageInTicks);
        this.animateInterestAndShaking(wolf, this.partialTicks);
    }

    private void animateInterestAndShaking(T wolf, float partialTicks) {
        boolean interested = wolf.m_30429_();
        boolean shaking = ((WolfAccessor)wolf).getIsShaking();
        if (interested || shaking) {
            this.head.f_104205_ = (interested ? wolf.m_30448_(partialTicks) : 0.0f) + (shaking ? wolf.m_30432_(partialTicks, 0.0f) : 0.0f);
        }
        if (shaking) {
            this.upperBody.f_104205_ = wolf.m_30432_(partialTicks, -0.08f);
            this.body.f_104205_ = wolf.m_30432_(partialTicks, -0.16f);
            this.tail.f_104205_ = wolf.m_30432_(partialTicks, -0.2f);
        }
    }

    private void animateHeadLookTarget(float yRot, float xRot) {
        this.head.f_104203_ = xRot * ((float)Math.PI / 180);
        this.head.f_104204_ = yRot * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

