/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.renderer.model;

import com.infamous.all_bark_all_bite.client.renderer.model.animation.HoundmasterAnimation;
import com.infamous.all_bark_all_bite.common.entity.houndmaster.Houndmaster;
import com.infamous.all_bark_all_bite.mixin.IllagerModelAccessor;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.monster.AbstractIllager;

public class HoundmasterModel<T extends Houndmaster>
extends IllagerModel<T> {
    public static final String BODY = "body";
    public static final String HEAD = "head";
    public static final String LEFT_ARM = "left_arm";
    public static final String WHISTLE = "whistle";
    public static final String RIGHT_ARM = "right_arm";
    public static final String LEFT_LEG = "left_leg";
    public static final String RIGHT_LEG = "right_leg";
    private final ModelPart whistle;

    public HoundmasterModel(ModelPart root) {
        super(root);
        this.m_102934_().f_104207_ = true;
        ((IllagerModelAccessor)((Object)this)).getArms().f_104207_ = false;
        this.whistle = root.m_171324_(LEFT_ARM).m_171324_(WHISTLE);
        this.whistle.f_104207_ = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition head = root.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-4.0f, -3.25f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(24, 63).m_171488_(-3.0f, -3.25f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-8.5f, (float)0.0f));
        PartDefinition head_r1 = hat.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(5.0E-4f, -6.7386f, -1.6254f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-0.0387f, (float)4.5468f, (float)-1.1352f, (float)0.1739f, (float)-0.0636f));
        PartDefinition head_r2 = hat.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(0.0f, -6.6438f, -1.388f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.25f, (float)-0.2887f, (float)4.5468f, (float)-0.8294f, (float)-0.0764f, (float)0.0607f));
        PartDefinition head_r3 = hat.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(-0.0012f, -6.64f, -1.412f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.2887f, (float)4.5468f, (float)-1.1318f, (float)-0.1996f, (float)0.066f));
        PartDefinition head_r4 = hat.m_171599_("head_r4", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(0.0f, -6.7495f, -1.6145f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)-0.0387f, (float)4.5468f, (float)-0.8287f, (float)0.058f, (float)-0.0211f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition beard = head.m_171599_("beard", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171488_(-3.5f, -2.0f, -0.75f, 7.0f, 5.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition leftArm = root.m_171599_(LEFT_ARM, CubeListBuilder.m_171558_().m_171514_(32, 33).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 33).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.15f)).m_171555_(false), PartPose.m_171419_((float)5.5f, (float)-0.75f, (float)0.0f));
        PartDefinition left_arm_r1 = leftArm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(48, 17).m_171480_().m_171488_(-2.0f, -2.05f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)8.3f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition whistle = leftArm.m_171599_(WHISTLE, CubeListBuilder.m_171558_().m_171514_(33, 80).m_171488_(-1.5f, -2.0f, -3.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 80).m_171488_(-1.5f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)9.0f, (float)-2.0f));
        PartDefinition rightArm = root.m_171599_(RIGHT_ARM, CubeListBuilder.m_171558_().m_171514_(32, 33).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 33).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)-5.5f, (float)-0.75f, (float)0.0f));
        PartDefinition right_arm_r1 = rightArm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(48, 17).m_171488_(-2.0f, -2.05f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)-1.0f, (float)8.3f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -14.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 39).m_171488_(-4.0f, -14.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.4f)).m_171514_(32, 49).m_171488_(-4.0f, -13.75f, -3.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_(LEFT_LEG, CubeListBuilder.m_171558_().m_171514_(32, 17).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)12.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_(RIGHT_LEG, CubeListBuilder.m_171558_().m_171514_(32, 17).m_171480_().m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)12.0f, (float)0.0f));
        PartDefinition arms = root.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)128);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.whistle.f_104207_ = ((Houndmaster)((Object)entity)).isWhistling();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (this.f_102609_ || ((Houndmaster)((Object)entity)).m_6768_() != AbstractIllager.IllagerArmPose.NEUTRAL) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            this.animateLookTarget(netHeadYaw, headPitch);
            this.m_233381_(((Houndmaster)((Object)entity)).animationController.idleAnimationState, HoundmasterAnimation.HOUNDMASTER_IDLE, ageInTicks);
            this.m_233381_(((Houndmaster)((Object)entity)).animationController.walkAnimationState, HoundmasterAnimation.HOUNDMASTER_WALK, ageInTicks);
            this.m_233381_(((Houndmaster)((Object)entity)).animationController.whistleAnimationState, HoundmasterAnimation.HOUNDMASTER_SUMMON, ageInTicks);
        }
    }

    private void animateLookTarget(float netHeadYaw, float headPitch) {
        this.m_5585_().f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.m_5585_().f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

