/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.renderer.model.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ItemInMouthLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Vector3f BABY_HEAD_OFFSET = new Vector3f(0.0f, 1.0f, 2.0f);
    private static final Vector3f MOUTH_OFFSET = new Vector3f(0.944f, 2.4f, -6.72f);
    private static final float BABY_HEAD_SCALE = 2.0f;
    private final ItemInHandRenderer itemInHandRenderer;

    public ItemInMouthLayer(RenderLayerParent<T, M> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
        super(renderLayerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float animPosDelta, float lerpAnimSpeed, float partialTicks, float bob, float lerpYRot, float lerpXRot) {
        ItemStack mainHandStack = entity.m_21205_();
        if (!mainHandStack.m_41619_()) {
            poseStack.m_85836_();
            if (this.m_117386_().f_102610_) {
                if (this.shouldScaleHead()) {
                    float headScale = 1.5f / this.getBabyHeadScale();
                    poseStack.m_85841_(headScale, headScale, headScale);
                }
                Vector3f babyHeadOffset = this.getBabyHeadOffset();
                poseStack.m_85837_((double)(babyHeadOffset.m_122239_() / 16.0f), (double)(babyHeadOffset.m_122260_() / 16.0f), (double)(babyHeadOffset.m_122269_() / 16.0f));
            }
            this.renderMouthWithItem(poseStack, bufferSource, packedLight, entity, mainHandStack);
            poseStack.m_85849_();
        }
    }

    private void renderMouthWithItem(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, ItemStack mainHandStack) {
        poseStack.m_85836_();
        ModelPart head = ((HeadedModel)this.m_117386_()).m_5585_();
        head.m_104299_(poseStack);
        Vector3f mouthOffset = this.getMouthOffset();
        poseStack.m_85837_((double)(mouthOffset.m_122239_() / 16.0f), (double)(mouthOffset.m_122260_() / 16.0f), (double)(mouthOffset.m_122269_() / 16.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        this.itemInHandRenderer.m_109322_(entity, mainHandStack, ItemTransforms.TransformType.GROUND, false, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    protected boolean shouldScaleHead() {
        return false;
    }

    protected float getBabyHeadScale() {
        return 2.0f;
    }

    protected Vector3f getBabyHeadOffset() {
        return BABY_HEAD_OFFSET;
    }

    protected Vector3f getMouthOffset() {
        return MOUTH_OFFSET;
    }
}

