/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.hunter;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.HunterAi;
import com.infamous.all_bark_all_bite.common.util.ai.LongJumpAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StalkAndPounce<E extends PathfinderMob>
extends Behavior<E> {
    private static final int CROUCH_ANIMATION_DURATION = 15;
    private static final int PATH_INTERVAL = 10;
    public static final double INITIAL_VISION_OFFSET = 0.5;
    private static final double MIN_Y_DELTA = 0.05;
    private static final long TIMEOUT_TO_GET_WITHIN_POUNCE_RANGE = 200L;
    private final float speedModifier;
    private final int pounceDistance;
    private final int pounceHeight;
    private int calculatePathCounter;
    private int crouchAnimationTimer;
    private State state = State.DONE;
    private final BiPredicate<E, LivingEntity> stopStalkingWhen;
    private final BiConsumer<E, LivingEntity> onTargetErased;

    public StalkAndPounce(float speedModifier, int pounceDistance, int pounceHeight, BiPredicate<E, LivingEntity> stopStalkingWhen) {
        this(speedModifier, pounceDistance, pounceHeight, stopStalkingWhen, (mob, le) -> {});
    }

    public StalkAndPounce(float speedModifier, int pounceDistance, int pounceHeight, BiPredicate<E, LivingEntity> stopStalkingWhen, BiConsumer<E, LivingEntity> onTargetErased) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.pounceDistance = pounceDistance;
        this.pounceHeight = pounceHeight;
        this.stopStalkingWhen = stopStalkingWhen;
        this.onTargetErased = onTargetErased;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        boolean canStalk;
        boolean bl = canStalk = this.canStalk(mob) && mob.m_20280_((Entity)this.getStalkTarget(mob).get()) > (double)Mth.m_144944_((int)this.pounceDistance);
        if (!canStalk) {
            this.clearTarget(mob);
        }
        return canStalk;
    }

    private void clearTarget(E mob) {
        this.getStalkTarget(mob).ifPresent(stalkTarget -> this.onTargetErased.accept(mob, (LivingEntity)stalkTarget));
        HunterAi.stopHunting(mob);
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        this.calculatePathCounter = 10;
        this.state = State.STALK;
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean canStillUse(ServerLevel level, E mob, long gameTime) {
        switch (this.state) {
            case STALK: {
                return this.canStalk(mob);
            }
            case CROUCH_ANIMATION: {
                return this.canCrouch(mob);
            }
            case POUNCE: {
                return this.canPounce(mob);
            }
            case MID_POUNCE: {
                return this.isMidPounce(mob);
            }
        }
        return false;
    }

    private boolean canStalk(E mob) {
        if (mob.m_5803_()) {
            return false;
        }
        LivingEntity stalkTarget = this.getStalkTarget(mob).orElse(null);
        return this.isValidStalkTarget(mob, stalkTarget) && !mob.m_217003_(Pose.CROUCHING);
    }

    private boolean isValidStalkTarget(E mob, @Nullable LivingEntity stalkTarget) {
        return stalkTarget != null && stalkTarget.m_6084_() && ((PathfinderMob)mob).f_19853_ == stalkTarget.f_19853_ && !AiUtil.isTiredOfTryingToReachTarget(mob, 200L) && !AiUtil.isLookingAtMe(mob, stalkTarget, 0.5) && !this.stopStalkingWhen.test(mob, stalkTarget);
    }

    private Optional<LivingEntity> getStalkTarget(E mob) {
        return HunterAi.getHuntTarget(mob);
    }

    private boolean canCrouch(E mob) {
        LivingEntity stalkTarget = this.getStalkTarget(mob).orElse(null);
        return this.isValidStalkTarget(mob, stalkTarget);
    }

    private boolean canPounce(E mob) {
        LivingEntity stalkTarget;
        boolean canPounce = false;
        if (mob.m_217003_(Pose.CROUCHING) && this.isValidStalkTarget(mob, stalkTarget = (LivingEntity)this.getStalkTarget(mob).orElse(null))) {
            canPounce = AiUtil.isPathClear(mob, stalkTarget, this.pounceDistance, this.pounceHeight);
        }
        if (!canPounce) {
            AiUtil.resetPose(mob, Pose.CROUCHING);
        }
        return canPounce;
    }

    private boolean isMidPounce(E mob) {
        double yD = mob.m_20184_().f_82480_;
        return Mth.m_144952_((double)yD) >= 0.05 || !mob.m_20096_();
    }

    protected void tick(ServerLevel level, E mob, long gameTime) {
        this.getStalkTarget(mob).ifPresent(st -> BehaviorUtils.m_22595_((LivingEntity)mob, (LivingEntity)st));
        switch (this.state) {
            case STALK: {
                LivingEntity stalkTarget = this.getStalkTarget(mob).get();
                if (mob.m_20280_((Entity)stalkTarget) <= (double)Mth.m_144944_((int)this.pounceDistance)) {
                    mob.m_20124_(Pose.CROUCHING);
                    GenericAi.stopWalking(mob);
                    this.crouchAnimationTimer = 0;
                    this.state = State.CROUCH_ANIMATION;
                    break;
                }
                if (this.calculatePathCounter <= 0) {
                    this.setWalkAndLookTarget(mob, stalkTarget);
                    this.calculatePathCounter = 10;
                    break;
                }
                --this.calculatePathCounter;
                break;
            }
            case CROUCH_ANIMATION: {
                if (this.crouchAnimationTimer++ < 15) break;
                this.state = State.POUNCE;
                break;
            }
            case POUNCE: {
                LivingEntity stalkTarget = this.getStalkTarget(mob).get();
                GenericAi.stopWalking(mob);
                BehaviorUtils.m_22595_(mob, (LivingEntity)stalkTarget);
                mob.m_20124_(Pose.LONG_JUMPING);
                LongJumpAi.setMidJump(mob);
                Vec3 jumpVector = stalkTarget.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                double xzDScale = (double)this.pounceDistance * 2.0 / 15.0;
                double yD = (double)this.pounceHeight * 3.0 / 10.0;
                mob.m_20256_(mob.m_20184_().m_82520_(jumpVector.f_82479_ * xzDScale, yD, jumpVector.f_82481_ * xzDScale));
                this.state = State.MID_POUNCE;
            }
        }
    }

    private void setWalkAndLookTarget(E mob, LivingEntity target) {
        AiUtil.setWalkAndLookTargetMemories(mob, (Entity)target, this.speedModifier, this.pounceDistance - 1);
    }

    protected void stop(ServerLevel level, E mob, long gameTime) {
        if (this.state == State.CROUCH_ANIMATION) {
            AiUtil.resetPose(mob, Pose.CROUCHING);
        }
        if (this.state == State.MID_POUNCE) {
            LongJumpAi.clearMidJump(mob);
            AiUtil.resetPose(mob, Pose.LONG_JUMPING);
        }
        this.state = State.DONE;
        this.clearTarget(mob);
    }

    static enum State {
        STALK,
        CROUCH_ANIMATION,
        POUNCE,
        MID_POUNCE,
        DONE;

    }
}

