/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.hunter;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.HunterAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StartHuntingPrey<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> canHuntPredicate;
    private final UniformInt huntCooldown;

    public StartHuntingPrey(Predicate<E> canHuntPredicate, UniformInt huntCooldown) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26340_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ADULTS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ADULTS.get()), (Object)MemoryStatus.REGISTERED));
        this.canHuntPredicate = canHuntPredicate;
        this.huntCooldown = huntCooldown;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        return this.canHuntPredicate.test(mob) && !HunterAi.hasAnyoneNearbyHuntedRecently(mob, GenericAi.getNearbyVisibleAdults(mob));
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        LivingEntity target = this.getHuntable(mob).get();
        int huntCooldownInTicks = this.huntCooldown.m_214085_(((Mob)mob).f_19853_.f_46441_);
        HunterAi.setHuntedRecently(mob, huntCooldownInTicks);
        HunterAi.setHuntTarget(mob, target);
        HunterAi.broadcastHuntTarget(GenericAi.getNearbyAdults(mob), target);
        HunterAi.broadcastHuntedRecently(this.huntCooldown, GenericAi.getNearbyVisibleAdults(mob));
    }

    private Optional<LivingEntity> getHuntable(E mob) {
        return HunterAi.getNearestVisibleHuntable(mob);
    }
}

