/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.long_jump;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.LongJumpAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class LongJumpToTarget<E extends Mob>
extends Behavior<E> {
    private static final int TIME_OUT_DURATION = 200;
    private final UniformInt timeBetweenLongJumps;
    protected final float maxJumpVelocity;
    @Nullable
    protected Vec3 initialPosition;
    @Nullable
    protected Vec3 chosenJump;
    protected long prepareJumpStart;
    private final Function<E, SoundEvent> getJumpSound;
    private final int prepareJumpDuration;
    private final Predicate<BlockState> acceptableLandingSpot;

    public LongJumpToTarget(UniformInt timeBetweenLongJumps, float maxJumpVelocity, Function<E, SoundEvent> getJumpSound, int prepareJumpDuration) {
        this(timeBetweenLongJumps, maxJumpVelocity, getJumpSound, prepareJumpDuration, bs -> false);
    }

    public LongJumpToTarget(UniformInt timeBetweenLongJumps, float maxJumpVelocity, Function<E, SoundEvent> getJumpSound, int prepareJumpDuration, Predicate<BlockState> acceptableLandingSpot) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.LONG_JUMP_TARGET.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), 200);
        this.timeBetweenLongJumps = timeBetweenLongJumps;
        this.maxJumpVelocity = maxJumpVelocity;
        this.getJumpSound = getJumpSound;
        this.prepareJumpDuration = prepareJumpDuration;
        this.acceptableLandingSpot = acceptableLandingSpot;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        boolean canStart;
        boolean bl = canStart = mob.m_20096_() && !mob.m_20069_() && !mob.m_20077_() && !level.m_8055_(mob.m_20183_()).m_60713_(Blocks.f_50719_) && this.hasValidJumpTarget((LivingEntity)mob);
        if (!canStart) {
            LongJumpAi.setLongJumpCooldown(mob, this.timeBetweenLongJumps.m_214085_(level.f_46441_) / 2);
            LongJumpAi.clearLongJumpTarget(mob);
        }
        return canStart;
    }

    private boolean hasValidJumpTarget(LivingEntity mob) {
        BlockPos initialPosition = mob.m_20183_();
        return this.getLongJumpTarget(mob).filter(target -> !target.m_6675_().equals((Object)initialPosition)).isPresent();
    }

    private Optional<PositionTracker> getLongJumpTarget(LivingEntity mob) {
        return LongJumpAi.getLongJumpTarget(mob);
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        this.chosenJump = null;
        this.pickCandidate(level, mob, gameTime);
        this.initialPosition = mob.m_20182_();
    }

    protected void pickCandidate(ServerLevel level, E mob, long gameTime) {
        Optional<PositionTracker> longJumpTarget = this.getLongJumpTarget((LivingEntity)mob);
        longJumpTarget.ifPresent(target -> {
            BlockPos targetBlockPosition = target.m_6675_();
            if (!this.isAcceptableLandingPosition(level, mob, targetBlockPosition)) {
                return;
            }
            Vec3 optimalJumpVector = LongJumpAi.calculateOptimalJumpVector(mob, target.m_7024_(), this.maxJumpVelocity, LongJumpAi.ALLOWED_ANGLES);
            if (optimalJumpVector == null) {
                return;
            }
            mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, target);
            this.chosenJump = optimalJumpVector;
            this.prepareJumpStart = gameTime;
        });
    }

    protected boolean isAcceptableLandingPosition(ServerLevel level, E mob, BlockPos targetPosition) {
        BlockPos currentPosition = mob.m_20183_();
        int x = currentPosition.m_123341_();
        int z = currentPosition.m_123343_();
        if (x == targetPosition.m_123341_() && z == targetPosition.m_123343_()) {
            return false;
        }
        if (!mob.m_21573_().m_6342_(targetPosition) && !this.acceptableLandingSpot.test(level.m_8055_(targetPosition.m_7495_()))) {
            return false;
        }
        return mob.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)((Mob)mob).f_19853_, (BlockPos.MutableBlockPos)targetPosition.m_122032_())) == 0.0f;
    }

    protected boolean canStillUse(ServerLevel level, E mob, long gameTime) {
        boolean canStillUse;
        boolean bl = canStillUse = this.initialPosition != null && this.initialPosition.equals((Object)mob.m_20182_()) && !mob.m_20072_() && (this.chosenJump != null || this.hasValidJumpTarget((LivingEntity)mob));
        if (!canStillUse && !LongJumpAi.isMidJump(mob)) {
            LongJumpAi.setLongJumpCooldown(mob, this.timeBetweenLongJumps.m_214085_(level.f_46441_) / 2);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26371_);
            LongJumpAi.clearLongJumpTarget(mob);
        }
        return canStillUse;
    }

    protected void tick(ServerLevel level, E mob, long gameTime) {
        if (this.chosenJump != null && gameTime - this.prepareJumpStart >= (long)this.prepareJumpDuration) {
            mob.m_146922_(((Mob)mob).f_20883_);
            mob.m_147244_(true);
            double jumpLength = this.chosenJump.m_82553_();
            double boostedJumpLength = jumpLength + mob.m_182332_();
            mob.m_20256_(this.chosenJump.m_82490_(boostedJumpLength / jumpLength));
            mob.m_6274_().m_21879_(MemoryModuleType.f_148200_, (Object)true);
            level.m_6269_(null, mob, this.getJumpSound.apply(mob), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }
}

