/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;

public class Eat
extends Behavior<Animal> {
    private final Consumer<Animal> onEaten;
    private int eatRemainingTicks;

    public Eat(Consumer<Animal> onEaten) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26355_, (Object)MemoryStatus.VALUE_ABSENT));
        this.onEaten = onEaten;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Animal animal) {
        if (animal.m_6117_()) {
            return false;
        }
        ItemStack eatItem = this.getEatItem(animal);
        return this.canEat(animal, eatItem);
    }

    private ItemStack getEatItem(Animal animal) {
        return animal.m_21120_(InteractionHand.MAIN_HAND);
    }

    private boolean canEat(Animal animal, ItemStack itemStack) {
        return animal.m_6898_(itemStack) && !animal.m_6274_().m_21874_(MemoryModuleType.f_26372_) && animal.m_20096_() && !animal.m_5803_();
    }

    protected void start(ServerLevel level, Animal animal, long gameTime) {
        int useDuration = this.getEatItem(animal).m_41779_();
        this.eatRemainingTicks = useDuration = Mth.m_14045_((int)useDuration, (int)16, (int)32);
        animal.m_6672_(InteractionHand.MAIN_HAND);
    }

    protected boolean canStillUse(ServerLevel level, Animal animal, long gameTime) {
        ItemStack eatItem = this.getEatItem(animal);
        if (!animal.m_6117_() || animal.m_21211_() != eatItem) {
            return false;
        }
        return this.canEat(animal, eatItem) && this.eatRemainingTicks >= 0;
    }

    protected void tick(ServerLevel level, Animal animal, long gameTime) {
        --this.eatRemainingTicks;
        if (this.eatRemainingTicks <= 0) {
            animal.m_5810_();
            ItemStack eatItem = this.getEatItem(animal);
            AiUtil.animalEat(animal, eatItem);
            eatItem.m_41774_(1);
            this.onEaten.accept(animal);
        }
    }

    protected void stop(ServerLevel level, Animal animal, long gameTime) {
        if (animal.m_21211_() == this.getEatItem(animal)) {
            animal.m_5810_();
        }
    }
}

