/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.mixin.LivingEntityAccessor;
import com.infamous.all_bark_all_bite.mixin.MobAccessor;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class PickUpItemTrigger<E extends Mob>
extends Behavior<E> {
    private final BiConsumer<E, ItemEntity> pickUpItem;

    public PickUpItemTrigger(BiConsumer<E, ItemEntity> pickUpItem) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26332_, (Object)MemoryStatus.VALUE_PRESENT));
        this.pickUpItem = pickUpItem;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        ItemEntity nearestWantedItem = this.getNearestWantedItem(mob).get();
        Vec3i pickupReach = ((MobAccessor)mob).callGetPickupReach();
        if (mob.m_21531_() && mob.m_6084_() && !((LivingEntityAccessor)mob).getDead() && ForgeEventFactory.getMobGriefingEvent((Level)level, mob)) {
            AABB pickupBox = mob.m_20191_().m_82377_((double)pickupReach.m_123341_(), (double)pickupReach.m_123342_(), (double)pickupReach.m_123343_());
            if (nearestWantedItem.m_20191_().m_82381_(pickupBox)) {
                return !nearestWantedItem.m_213877_() && !nearestWantedItem.m_32055_().m_41619_() && !nearestWantedItem.m_32063_() && mob.m_7243_(nearestWantedItem.m_32055_());
            }
        }
        return false;
    }

    private Optional<ItemEntity> getNearestWantedItem(E mob) {
        return mob.m_6274_().m_21952_(MemoryModuleType.f_26332_);
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        this.pickUpItem.accept(mob, this.getNearestWantedItem(mob).get());
    }
}

