/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class PlayTagWithOtherBabies
extends Behavior<PathfinderMob> {
    private static final int MAX_FLEE_XZ_DIST = 20;
    private static final int MAX_FLEE_Y_DIST = 8;
    private final BiPredicate<ServerLevel, Vec3> validFleePos;
    private final float fleeSpeedModifier;
    private final float chaseSpeedModifier;
    private static final int MAX_CHASERS_PER_TARGET = 5;
    private static final int AVERAGE_WAIT_TIME_BETWEEN_RUNS = 10;

    public PlayTagWithOtherBabies(float fleeSpeedModifier, float chaseSpeedModifier) {
        this((level, vec3) -> true, fleeSpeedModifier, chaseSpeedModifier);
    }

    public PlayTagWithOtherBabies(BiPredicate<ServerLevel, Vec3> validFleePos, float fleeSpeedModifier, float chaseSpeedModifier) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABIES.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.REGISTERED));
        this.validFleePos = validFleePos;
        this.fleeSpeedModifier = fleeSpeedModifier;
        this.chaseSpeedModifier = chaseSpeedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob mob) {
        return mob.m_6162_() && MiscUtil.oneInChance(mob.m_217043_(), 10) && this.hasFriendsNearby(mob);
    }

    protected void start(ServerLevel level, PathfinderMob mob, long gameTime) {
        LivingEntity chasingMe = this.seeIfSomeoneIsChasingMe((LivingEntity)mob);
        if (chasingMe != null) {
            this.fleeFromChaser(level, mob);
        } else {
            Optional<LivingEntity> someoneBeingChased = this.findSomeoneBeingChased(mob);
            if (someoneBeingChased.isPresent()) {
                this.chaseKid(mob, someoneBeingChased.get());
            } else {
                this.findSomeoneToChase(mob).ifPresent(kid -> this.chaseKid(mob, (LivingEntity)kid));
            }
        }
    }

    private void fleeFromChaser(ServerLevel level, PathfinderMob mob) {
        for (int i = 0; i < 10; ++i) {
            Vec3 fleePos = LandRandomPos.m_148488_((PathfinderMob)mob, (int)20, (int)8);
            if (fleePos == null || !this.validFleePos.test(level, fleePos)) continue;
            mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(fleePos, this.fleeSpeedModifier, 0));
            return;
        }
    }

    private void chaseKid(PathfinderMob mob, LivingEntity kid) {
        Brain brain = mob.m_6274_();
        brain.m_21879_(MemoryModuleType.f_26374_, (Object)kid);
        AiUtil.setWalkAndLookTargetMemories((LivingEntity)mob, (Entity)kid, this.chaseSpeedModifier, 1);
    }

    private Optional<LivingEntity> findSomeoneToChase(PathfinderMob mob) {
        return this.getFriendsNearby(mob).stream().findAny();
    }

    private Optional<LivingEntity> findSomeoneBeingChased(PathfinderMob mob) {
        Map<LivingEntity, Integer> friendsToChasers = this.checkHowManyChasersEachFriendHas(mob);
        return friendsToChasers.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(entry -> (Integer)entry.getValue() > 0 && (Integer)entry.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private Map<LivingEntity, Integer> checkHowManyChasersEachFriendHas(PathfinderMob mob) {
        HashMap map = Maps.newHashMap();
        this.getFriendsNearby(mob).stream().filter(this::isChasingSomeone).forEach(chaser -> map.compute(this.whoAreYouChasing((LivingEntity)chaser), (friend, chasers) -> chasers == null ? 1 : chasers + 1));
        return map;
    }

    private List<LivingEntity> getFriendsNearby(PathfinderMob mob) {
        return GenericAi.getNearestVisibleBabies(mob);
    }

    private LivingEntity whoAreYouChasing(LivingEntity mob) {
        return (LivingEntity)mob.m_6274_().m_21952_(MemoryModuleType.f_26374_).get();
    }

    @Nullable
    private LivingEntity seeIfSomeoneIsChasingMe(LivingEntity mob) {
        return GenericAi.getNearestVisibleBabies(mob).stream().filter(baby -> this.isFriendChasingMe(mob, (LivingEntity)baby)).findAny().orElse(null);
    }

    private boolean isChasingSomeone(LivingEntity mob) {
        return mob.m_6274_().m_21952_(MemoryModuleType.f_26374_).isPresent();
    }

    private boolean isFriendChasingMe(LivingEntity mob, LivingEntity friend) {
        return friend.m_6274_().m_21952_(MemoryModuleType.f_26374_).filter(target -> target == mob).isPresent();
    }

    private boolean hasFriendsNearby(PathfinderMob mob) {
        return !GenericAi.getNearestVisibleBabies(mob).isEmpty();
    }
}

