/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pack;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.PackAi;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ValidateFollowers
extends Behavior<LivingEntity> {
    public ValidateFollowers() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean m_6114_(ServerLevel level, LivingEntity leader) {
        return PackAi.hasFollowers(leader);
    }

    protected void m_6735_(ServerLevel level, LivingEntity leader, long gameTime) {
        PackAi.getFollowerManager(leader).get().tick(level, e -> this.isValidFollower((Entity)e, leader), this::onFollowerInvalid);
    }

    private boolean isValidFollower(Entity entity, LivingEntity leader) {
        if (entity instanceof LivingEntity) {
            LivingEntity follower = (LivingEntity)entity;
            return !follower.m_21224_() && follower.f_19853_ == leader.f_19853_ && PackAi.isFollower(follower) && AiUtil.isSameTypeAndFriendly(leader, follower) && follower.m_19950_((Entity)leader, AiUtil.getFollowRange(follower)) && leader.f_19853_.m_6857_().m_61935_(follower.m_20191_());
        }
        return false;
    }

    private void onFollowerInvalid(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity follower = (LivingEntity)entity;
            PackAi.eraseLeader(follower);
        }
    }
}

