/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pet;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.behavior.TargetBehavior;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.TrustAi;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class DefendLikedPlayer<E extends Mob>
extends TargetBehavior<E> {
    private LivingEntity trustedLastHurtBy;
    private LivingEntity trustedLastHurt;
    private int timestamp;
    private final Predicate<LivingEntity> selector;

    public DefendLikedPlayer() {
        this(le -> le.m_21214_() != null && le.m_21215_() < le.f_19797_ + 600);
    }

    public DefendLikedPlayer(Predicate<LivingEntity> selector) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_217778_, (Object)MemoryStatus.VALUE_PRESENT), false);
        this.selector = selector;
    }

    public boolean checkExtraStartConditions(ServerLevel level, E mob) {
        LivingEntity likedPlayer;
        this.trustedLastHurt = likedPlayer = TrustAi.getLikedPlayer(mob).get();
        this.trustedLastHurtBy = likedPlayer.m_21188_();
        int lastHurtByMobTimestamp = likedPlayer.m_21213_();
        return lastHurtByMobTimestamp != this.timestamp && this.canAttack(mob, this.trustedLastHurtBy, this.getTargetingConditions(mob));
    }

    private TargetingConditions getTargetingConditions(E mob) {
        return TargetingConditions.m_148352_().m_26883_(AiUtil.getFollowRange(mob)).m_26888_(this.selector);
    }

    @Override
    public void start(ServerLevel level, E mob, long gameTime) {
        StartAttacking.m_24213_(mob, (LivingEntity)this.trustedLastHurtBy);
        this.timestamp = this.trustedLastHurt.m_21213_();
        super.start(level, mob, gameTime);
    }
}

