/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.compat;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.block.DrumBlock;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.util.ai.CommandAi;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DICompat {
    public static final int DI_WANDER_COMMAND = 0;
    public static final int DI_STAY_COMMAND = 1;
    public static final int DI_FOLLOW_COMMAND = 2;
    private static final String DI_COMMAND_MESSAGE_KEY = "message.domesticationinnovation.command_";
    private static final int DI_DRUM_EFFECT_RADIUS = 32;

    public static boolean isDITrinaryCommandSystemEnabled() {
        return (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get();
    }

    public static Optional<Integer> getDICommand(Entity pet) {
        if (pet instanceof IComandableMob) {
            IComandableMob comandableMob = (IComandableMob)pet;
            return Optional.of(comandableMob.getCommand());
        }
        return Optional.empty();
    }

    public static void setDICommand(Entity pet, LivingEntity user, int command) {
        if (DICompat.isDITrinaryCommandSystemEnabled()) {
            if (pet instanceof IComandableMob) {
                IComandableMob comandableMob = (IComandableMob)pet;
                comandableMob.setCommand(command);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    comandableMob.sendCommandMessage(player, command, pet.m_7755_());
                }
            } else if (pet instanceof Dog) {
                Dog dog = (Dog)pet;
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_5661_((Component)Component.m_237110_((String)(DI_COMMAND_MESSAGE_KEY + command), (Object[])new Object[]{dog.m_7755_()}), true);
                }
            }
        }
    }

    public static boolean hasDIAmphibiousEnchant(Mob mob) {
        return TameableUtils.isTamed((Entity)mob) && TameableUtils.hasEnchant((LivingEntity)mob, (Enchantment)DIEnchantmentRegistry.AMPHIBIOUS);
    }

    public static void handleDIDrum(Player player, Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60734_() instanceof DrumBlock) {
            int command = (Integer)blockState.m_61143_((Property)DrumBlock.COMMAND);
            Predicate<Entity> tamed = entity -> TameableUtils.isTamed((Entity)entity) && TameableUtils.getOwnerUUIDOf((Entity)entity) != null && TameableUtils.getOwnerUUIDOf((Entity)entity).equals(player.m_20148_());
            AABB area = new AABB(blockPos.m_7918_(-32, -32, -32), blockPos.m_7918_(32, 32, 32));
            for (Animal animal : level.m_6443_(Animal.class, area, EntitySelector.f_20408_.and(tamed))) {
                switch (command) {
                    case 0: {
                        CommandAi.commandFree((PathfinderMob)animal, (LivingEntity)player, false);
                        break;
                    }
                    case 1: {
                        CommandAi.commandSit((PathfinderMob)animal, (LivingEntity)player, false);
                        break;
                    }
                    case 2: {
                        CommandAi.commandFollow((PathfinderMob)animal, (LivingEntity)player, false);
                    }
                }
            }
        }
    }

    public static boolean isTamed(Entity entity) {
        return TameableUtils.isTamed((Entity)entity);
    }
}

