/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;

public class DogSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    public int m_7995_(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (spawnFriendlies && level.m_46469_().m_46207_(GameRules.f_46134_)) {
            --this.nextTick;
            if (this.nextTick <= 0) {
                this.nextTick = 1200;
                ServerPlayer player = level.m_8890_();
                if (player != null) {
                    RandomSource random = level.f_46441_;
                    int xOffset = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
                    int zOffset = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
                    BlockPos targetPos = player.m_20183_().m_7918_(xOffset, 0, zOffset);
                    int horizontalOffset = 10;
                    if (level.m_151572_(targetPos.m_123341_() - horizontalOffset, targetPos.m_123343_() - horizontalOffset, targetPos.m_123341_() + horizontalOffset, targetPos.m_123343_() + horizontalOffset) && NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)targetPos, (EntityType)((EntityType)ABABEntityTypes.DOG.get()))) {
                        if (level.m_8736_(targetPos, 2)) {
                            return this.spawnInVillage(level, targetPos);
                        }
                        if (level.m_215010_().m_220491_(targetPos, ABABTags.DOGS_SPAWN_IN).m_73603_()) {
                            return this.spawnInHut(level, targetPos);
                        }
                    }
                }
            }
        }
        return 0;
    }

    private int spawnInVillage(ServerLevel level, BlockPos blockPos) {
        List nearbyDogs;
        int horizontalBound = 48;
        if (level.m_8904_().m_27121_(h -> h.m_203565_(PoiTypes.f_218060_), blockPos, horizontalBound, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (nearbyDogs = level.m_45976_(Dog.class, new AABB(blockPos).m_82377_((double)horizontalBound, 8.0, (double)horizontalBound))).size() < 5) {
            return this.spawnDog(blockPos, level);
        }
        return 0;
    }

    private int spawnInHut(ServerLevel level, BlockPos blockPos) {
        int horizontalBound = 16;
        List nearbyDogs = level.m_45976_(Dog.class, new AABB(blockPos).m_82377_((double)horizontalBound, 8.0, (double)horizontalBound));
        return nearbyDogs.size() < 1 ? this.spawnDog(blockPos, level) : 0;
    }

    private int spawnDog(BlockPos blockPos, ServerLevel level) {
        Dog dog = (Dog)((EntityType)ABABEntityTypes.DOG.get()).m_20615_((Level)level);
        if (dog == null) {
            return 0;
        }
        dog.m_20035_(blockPos, 0.0f, 0.0f);
        if (ForgeHooks.canEntitySpawn((Mob)dog, (LevelAccessor)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), null, (MobSpawnType)MobSpawnType.NATURAL) == -1) {
            return 0;
        }
        dog.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockPos), MobSpawnType.NATURAL, null, null);
        level.m_47205_((Entity)dog);
        return 1;
    }
}

