/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public interface OwnableMob
extends OwnableEntity {
    public static final String OWNER_TAG = "Owner";

    default public LivingEntity cast() {
        return (LivingEntity)this;
    }

    default public void writeOwnerNBT(CompoundTag tag) {
        if (this.m_21805_() != null) {
            tag.m_128362_(OWNER_TAG, this.m_21805_());
        }
    }

    default public void readOwnerNBT(CompoundTag tag) {
        if (tag.m_128403_(OWNER_TAG)) {
            UUID uuid = tag.m_128342_(OWNER_TAG);
            this.setOwnerUUID(uuid);
        }
    }

    default public Optional<Team> getOwnerTeam() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            return Optional.ofNullable(owner.m_5647_());
        }
        return Optional.empty();
    }

    default public boolean isOwnerAlliedTo(Entity other) {
        LivingEntity owner = this.getOwner();
        if (other == owner) {
            return true;
        }
        if (owner != null) {
            return owner.m_7307_(other);
        }
        return false;
    }

    public void setOwnerUUID(@Nullable UUID var1);

    default public void setOwner(LivingEntity owner) {
        this.setOwnerUUID(owner.m_20148_());
        this.setOwnerId(owner.m_19879_());
        this.setCachedOwner(owner);
    }

    default public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public int getOwnerId();

    public void setOwnerId(int var1);

    @Nullable
    default public LivingEntity getOwner() {
        LivingEntity owner;
        UUID ownerUUID = this.m_21805_();
        if (ownerUUID == null) {
            return null;
        }
        LivingEntity cachedOwner = this.getCachedOwner();
        int ownerId = this.getOwnerId();
        if (cachedOwner != null && !cachedOwner.m_213877_() && cachedOwner.m_19879_() == ownerId) {
            return cachedOwner;
        }
        Level level = this.cast().f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            owner = AiUtil.getLivingEntityFromUUID(serverLevel, ownerUUID).orElse(null);
            this.setCachedOwner(owner);
            this.setOwnerId(owner != null ? owner.m_19879_() : 0);
            return owner;
        }
        if (ownerId != 0) {
            owner = AiUtil.getLivingEntityFromId(this.cast().f_19853_, ownerId).orElse(null);
            this.setCachedOwner(owner);
            return owner;
        }
        return null;
    }

    public void setCachedOwner(@Nullable LivingEntity var1);

    @Nullable
    public LivingEntity getCachedOwner();
}

