/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;

public interface ShakingMob {
    public static final byte START_SHAKING_ID = 8;
    public static final byte STOP_SHAKING_ID = 56;
    public static final float MAX_SHAKE_TIME_IN_SECONDS = 2.0f;
    public static final float SECONDS_PER_TICK = 0.05f;
    public static final float SECONDS_AFTER_START_TO_SPLASH = 0.4f;

    default public PathfinderMob cast() {
        return (PathfinderMob)this;
    }

    default public void tickShaking() {
        PathfinderMob self = this.cast();
        if (self.m_20071_() && !self.f_19853_.f_46443_) {
            this.setIsWet(true);
            if (this.isShaking() && !self.f_19853_.f_46443_) {
                self.f_19853_.m_7605_((Entity)self, (byte)56);
                this.setIsShaking(false);
                this.setShakeAnims(0.0f, 0.0f);
            }
        } else if ((this.isWet() || this.isShaking()) && this.isShaking()) {
            if (((Float)this.getShakeAnims().right).floatValue() == 0.0f) {
                this.playShakeSound();
                self.m_146850_(GameEvent.f_223710_);
            }
            this.setShakeAnims(((Float)this.getShakeAnims().right).floatValue(), ((Float)this.getShakeAnims().right).floatValue() + 0.05f);
            if (((Float)this.getShakeAnims().left).floatValue() >= 2.0f) {
                if (!self.f_19853_.f_46443_) {
                    self.f_19853_.m_7605_((Entity)self, (byte)56);
                    this.setIsWet(false);
                    this.setIsShaking(false);
                    this.setShakeAnims(0.0f, 0.0f);
                }
            } else if (((Float)this.getShakeAnims().right).floatValue() > 0.4f) {
                int numParticles = (int)(Mth.m_14031_((float)((((Float)this.getShakeAnims().right).floatValue() - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3 deltaMovement = self.m_20184_();
                MiscUtil.addParticlesAroundSelf((LivingEntity)self, (ParticleOptions)ParticleTypes.f_123769_, numParticles, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_, 0.5, 0.8);
            }
        }
    }

    default public void aiStepShaking() {
        PathfinderMob self = this.cast();
        if (!self.f_19853_.f_46443_ && this.isWet() && !this.isShaking() && !self.m_21691_() && self.m_20096_()) {
            this.setIsShaking(true);
            this.setShakeAnims(0.0f, 0.0f);
            self.f_19853_.m_7605_((Entity)self, (byte)8);
        }
    }

    default public void handleShakingEvent(byte id) {
        if (id == 8) {
            this.setShakeAnims(0.0f, 0.0f);
        } else if (id == 56) {
            this.setShakeAnims(0.0f, 0.0f);
        }
    }

    default public float getBodyRollAngle(float partialTick, float initialZRot) {
        float bodyRollAngle = (Mth.m_14179_((float)partialTick, (float)((Float)this.getShakeAnims().left).floatValue(), (float)((Float)this.getShakeAnims().right).floatValue()) + initialZRot) / 1.8f;
        if (bodyRollAngle < 0.0f) {
            bodyRollAngle = 0.0f;
        } else if (bodyRollAngle > 1.0f) {
            bodyRollAngle = 1.0f;
        }
        return Mth.m_14031_((float)(bodyRollAngle * (float)Math.PI)) * Mth.m_14031_((float)(bodyRollAngle * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    default public void dieShaking() {
        this.setIsWet(false);
        this.setIsShaking(false);
        this.setShakeAnims(0.0f, 0.0f);
    }

    default public float getWetShade(float partialTicks) {
        return Math.min(0.5f + Mth.m_14179_((float)partialTicks, (float)((Float)this.getShakeAnims().left).floatValue(), (float)((Float)this.getShakeAnims().right).floatValue()) / 2.0f * 0.5f, 1.0f);
    }

    public boolean isWet();

    public void setIsWet(boolean var1);

    public boolean isShaking();

    public void setIsShaking(boolean var1);

    default public void setShakeAnims(float shakeAnimO, float shakeAnim) {
        this.getShakeAnims().setLeft((Object)Float.valueOf(shakeAnimO));
        this.getShakeAnims().setRight((Object)Float.valueOf(shakeAnim));
    }

    public MutablePair<Float, Float> getShakeAnims();

    public void playShakeSound();
}

