/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.entity.EntityAnimationController;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class SharedWolfAnimationController
extends EntityAnimationController<TamableAnimal> {
    private final EntityDataAccessor<Byte> tamableEntityFlags;
    public final AnimationState idleSitAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    private int idleSitDelayTicks;

    public SharedWolfAnimationController(TamableAnimal wolf, EntityDataAccessor<Byte> tamableEntityFlags, EntityDataAccessor<Pose> entityPose) {
        super(wolf, entityPose);
        this.tamableEntityFlags = tamableEntityFlags;
    }

    @Override
    public void onSyncedDataUpdatedAnimations(EntityDataAccessor<?> dataAccessor) {
        if (this.tamableEntityFlags.equals(dataAccessor)) {
            if (((TamableAnimal)this.entity).m_21825_()) {
                this.stopAllNonePoseAnimations();
                if (!this.idleSitAnimationState.m_216984_()) {
                    if (!this.sitAnimationState.m_216984_()) {
                        this.idleSitDelayTicks = 4;
                    }
                    this.sitAnimationState.m_216982_(((TamableAnimal)this.entity).f_19797_);
                }
            } else {
                this.sitAnimationState.m_216973_();
                this.idleSitAnimationState.m_216973_();
                this.idleSitDelayTicks = 0;
            }
        } else {
            super.onSyncedDataUpdatedAnimations(dataAccessor);
        }
    }

    @Override
    public void aiStepAnimations() {
        super.aiStepAnimations();
        if (this.idleSitDelayTicks > 0) {
            --this.idleSitDelayTicks;
        }
    }

    @Override
    public void tickAnimations() {
        this.tickBaby();
        if (!((TamableAnimal)this.entity).m_21825_()) {
            this.tickBasicAnimations();
        } else if (this.idleSitDelayTicks == 0) {
            this.sitAnimationState.m_216973_();
            this.idleSitAnimationState.m_216982_(((TamableAnimal)this.entity).f_19797_);
        }
        if (((TamableAnimal)this.entity).m_20089_() == Pose.DIGGING) {
            this.clientDiggingParticles(this.digAnimationState);
        }
    }

    private void clientDiggingParticles(AnimationState animationState) {
        if ((float)animationState.m_216981_() < 4500.0f) {
            RandomSource random = ((TamableAnimal)this.entity).m_217043_();
            BlockState blockStateOn = ((TamableAnimal)this.entity).m_20075_();
            if (blockStateOn.m_60799_() != RenderShape.INVISIBLE) {
                for (int particleCount = 0; particleCount < 10; ++particleCount) {
                    double x = ((TamableAnimal)this.entity).m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    double y = ((TamableAnimal)this.entity).m_20186_();
                    double z = ((TamableAnimal)this.entity).m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    ((TamableAnimal)this.entity).f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockStateOn), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

