/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.infamous.all_bark_all_bite.common.behavior.hunter.RememberIfHuntTargetWasKilled;
import com.infamous.all_bark_all_bite.common.behavior.hunter.StalkAndPounce;
import com.infamous.all_bark_all_bite.common.behavior.hunter.StartHuntingPrey;
import com.infamous.all_bark_all_bite.common.behavior.long_jump.LeapAtTarget;
import com.infamous.all_bark_all_bite.common.behavior.misc.CopyMemoryNoExpiry;
import com.infamous.all_bark_all_bite.common.behavior.misc.HurtByEntityTrigger;
import com.infamous.all_bark_all_bite.common.behavior.misc.Sprint;
import com.infamous.all_bark_all_bite.common.behavior.misc.UpdateActivity;
import com.infamous.all_bark_all_bite.common.behavior.misc.UpdateNeutralMob;
import com.infamous.all_bark_all_bite.common.behavior.misc.UpdateTarget;
import com.infamous.all_bark_all_bite.common.behavior.pet.DefendLikedPlayer;
import com.infamous.all_bark_all_bite.common.behavior.pet.OwnerHurtByTarget;
import com.infamous.all_bark_all_bite.common.behavior.pet.OwnerHurtTarget;
import com.infamous.all_bark_all_bite.common.behavior.pet.SitWhenOrderedTo;
import com.infamous.all_bark_all_bite.common.behavior.sleep.SleepOnGround;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AngerAi;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.HunterAi;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Position;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.schedule.Activity;

public class SharedWolfBrain {
    private static final UniformInt PLAY_START_INTERVAL = TimeUtil.m_145020_((int)10, (int)40);

    public static AnimalMakeLove createBreedBehavior(EntityType<? extends Wolf> type) {
        return new AnimalMakeLove(type, 1.0f);
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getFightPackage(BiPredicate<E, LivingEntity> huntTargetPredicate) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfBrain::canSprintWhileAttacking), (Object)((Object)new LeapAtTarget(0.4f, 2, 4, SharedWolfAi.LEAP_COOLDOWN)), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.0f), (Object)new MeleeAttack(20), new RememberIfHuntTargetWasKilled<E>(huntTargetPredicate, SharedWolfAi.TIME_BETWEEN_HUNTS), (Object)new EraseMemoryIf(BehaviorUtils::m_217126_, MemoryModuleType.f_26372_)));
    }

    private static boolean canSprintWhileAttacking(Wolf wolf) {
        return SharedWolfAi.canMove(wolf) && GenericAi.getAttackTarget((LivingEntity)wolf).map(at -> !wolf.m_217066_(at)).orElse(false) != false;
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getTargetPackage(BiConsumer<E, LivingEntity> onHurtByEntity, Predicate<E> canStartHunting) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new OwnerHurtByTarget<Wolf>(SharedWolfAi::canDefendOwner, SharedWolfAi::wantsToAttack), (Object)new RunIf(Predicate.not(TamableAnimal::m_21824_), new DefendLikedPlayer()), new OwnerHurtTarget<Wolf>(SharedWolfAi::canDefendOwner, SharedWolfAi::wantsToAttack), new HurtByEntityTrigger<E>(onHurtByEntity), (Object)new StartAttacking(SharedWolfAi::canStartAttacking, SharedWolfAi::findNearestValidAttackTarget), new StartHuntingPrey<E>(canStartHunting, SharedWolfAi.TIME_BETWEEN_HUNTS), (Object)new StopAttackingIfTargetInvalid(), (Object)new StopBeingAngryIfTargetDead()));
    }

    public static void onHurtBy(Wolf tamableAnimal) {
        SharedWolfAi.stopHoldingItemInMouth((LivingEntity)tamableAnimal);
        SharedWolfAi.clearStates((TamableAnimal)tamableAnimal, true);
        tamableAnimal.m_21839_(false);
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getUpdatePackage(List<Activity> activities, BiConsumer<E, Pair<Activity, Activity>> onActivityChanged) {
        return BrainUtil.createPriorityPairs(99, ImmutableList.of(new UpdateActivity<E>(activities, onActivityChanged), (Object)((Object)new UpdateTarget()), new UpdateNeutralMob()));
    }

    public static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getPanicPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfAi::canMove)));
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getSitPackage(RunOne<E> idleLookBehaviors, Behavior<E> beg) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of((Object)((Object)new SitWhenOrderedTo()), beg, idleLookBehaviors));
    }

    public static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getHuntPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of((Object)new RunIf(Predicate.not(LivingEntity::m_6162_), new StalkAndPounce<Wolf>(1.0f, 6, 3, SharedWolfBrain::adultStopHuntingWhen, SharedWolfBrain::onHuntTargetErased), true), (Object)new RunIf(LivingEntity::m_6162_, new StalkAndPounce<Wolf>(1.0f, 4, 2, SharedWolfBrain::babyStopHuntingWhen), true)));
    }

    private static boolean babyStopHuntingWhen(Wolf wolf, LivingEntity target) {
        return !target.m_6162_();
    }

    private static boolean adultStopHuntingWhen(Wolf wolf, LivingEntity target) {
        return !GenericAi.getNearbyAdults(wolf).isEmpty();
    }

    private static void onHuntTargetErased(Wolf wolf, LivingEntity target) {
        if (Sensor.m_182377_((LivingEntity)wolf, (LivingEntity)target)) {
            AngerAi.setAngerTargetIfCloserThanCurrent((LivingEntity)wolf, target, SharedWolfAi.ANGER_DURATION.m_214085_(wolf.m_217043_()));
            GenericAi.setAttackTargetIfCloserThanCurrent((Mob)wolf, target);
        }
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getAvoidPackage(RunOne<E> idleMovementBehaviors, RunOne<E> idleLookBehaviors) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfAi::canMove), (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.0f, (int)12, (boolean)true), idleMovementBehaviors, idleLookBehaviors, (Object)new EraseMemoryIf(SharedWolfBrain::wantsToStopFleeing, MemoryModuleType.f_26383_)));
    }

    private static boolean wantsToStopFleeing(Wolf wolf) {
        return !wolf.m_6162_() && wolf.m_21824_();
    }

    public static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getMeetPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfAi::canMove), (Object)new StayCloseToTarget(SharedWolfAi::getHowlPosition, SharedWolfAi.ADULT_FOLLOW_RANGE.m_142739_() - 1, SharedWolfAi.ADULT_FOLLOW_RANGE.m_142737_(), 1.0f), (Object)new EraseMemoryIf(SharedWolfBrain::wantsToStopFollowingHowl, (MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get())));
    }

    private static boolean wantsToStopFollowingHowl(Wolf wolf) {
        Optional<PositionTracker> howlPosition = SharedWolfAi.getHowlPosition((LivingEntity)wolf);
        if (howlPosition.isEmpty()) {
            return true;
        }
        PositionTracker tracker = howlPosition.get();
        return wolf.m_20182_().m_82509_((Position)tracker.m_7024_(), (double)SharedWolfAi.ADULT_FOLLOW_RANGE.m_142737_());
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getRestPackage(RunOne<E> idleLookBehaviors, boolean nocturnal) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new SleepOnGround<Wolf>(wolf -> SharedWolfAi.canSleep(wolf, nocturnal), SharedWolfAi::handleSleeping), (Object)new RunIf(Predicate.not(LivingEntity::m_5803_), idleLookBehaviors, true)));
    }

    public static Set<Pair<MemoryModuleType<?>, MemoryStatus>> getPanicConditions() {
        return ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static Set<Pair<MemoryModuleType<?>, MemoryStatus>> getSitConditions() {
        return ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static Set<Pair<MemoryModuleType<?>, MemoryStatus>> getRestConditions(MemoryModuleType<Unit> timeMemory) {
        return ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get()), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(timeMemory, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public static void fetchItem(LivingEntity livingEntity) {
        Brain brain = livingEntity.m_6274_();
        brain.m_21936_((MemoryModuleType)ABABMemoryModuleTypes.TIME_TRYING_TO_REACH_FETCH_ITEM.get());
        brain.m_21879_((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get(), (Object)true);
    }

    public static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getCountDownPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of((Object)new CountDownCooldownTicks(MemoryModuleType.f_217781_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    public static boolean canPerch(LivingEntity mob) {
        return GenericAi.getAttackTarget(mob).isEmpty() && !SharedWolfAi.isAlert(mob) && HunterAi.getHuntTarget(mob).isEmpty() && !mob.m_217003_(Pose.CROUCHING);
    }

    public static boolean isActivelyFollowing(LivingEntity wolf) {
        return wolf.m_6274_().m_21874_((MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get());
    }

    public static RunIf<Wolf> createMoveToTargetSink() {
        return new RunIf(SharedWolfAi::canMove, (Behavior)new MoveToTargetSink(), true);
    }

    public static RunIf<Wolf> createAnimalPanic() {
        return new RunIf(SharedWolfAi::shouldPanic, (Behavior)new AnimalPanic(1.0f), true);
    }

    public static CopyMemoryWithExpiry<Wolf, LivingEntity> copyToAvoidTarget(MemoryModuleType<? extends LivingEntity> copyMemory) {
        return new CopyMemoryWithExpiry(wolf -> SharedWolfAi.isNearDisliked(wolf, copyMemory), copyMemory, MemoryModuleType.f_26383_, SharedWolfAi.AVOID_DURATION);
    }

    public static RunIf<Wolf> createLookAtTargetSink() {
        return new RunIf(Predicate.not(LivingEntity::m_5803_), (Behavior)new LookAtTargetSink(45, 90), true);
    }

    public static <E extends Wolf> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> getFollowPackage(RunOne<E> idleMovementBehaviors, Behavior<E> beg, RunOne<E> idleLookBehaviors) {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfAi::canMove, 10), SharedWolfAi.createFollowOwner(1.0f), idleMovementBehaviors, beg, idleLookBehaviors));
    }

    public static Set<Pair<MemoryModuleType<?>, MemoryStatus>> getFollowConditions() {
        return ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static RunSometimes<Wolf> babySometimesHuntBaby() {
        return new RunSometimes(new CopyMemoryNoExpiry(LivingEntity::m_6162_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get()), PLAY_START_INTERVAL);
    }
}

