/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.dog;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABSensorTypes;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.CommandAi;
import com.infamous.all_bark_all_bite.common.util.ai.DigAi;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class DogAi {
    public static final Collection<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26355_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_217770_, (Object)((MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.DISABLE_WALK_TO_FETCH_ITEM.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.DOG_VIBRATION_LISTENER.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_DISABLED.get()), (Object[])new MemoryModuleType[]{(MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get(), (MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get(), (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get(), MemoryModuleType.f_26340_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26374_, (MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_NIGHT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get(), MemoryModuleType.f_217768_, (MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_SLEEPING.get(), MemoryModuleType.f_148198_, MemoryModuleType.f_217781_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_148199_, MemoryModuleType.f_148200_, MemoryModuleType.f_26371_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ADULTS.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_BABIES.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ALLIES.get(), MemoryModuleType.f_148194_, MemoryModuleType.f_148204_, MemoryModuleType.f_26367_, MemoryModuleType.f_26354_, MemoryModuleType.f_26331_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ADULTS.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ALLIES.get(), MemoryModuleType.f_148206_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABIES.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get(), MemoryModuleType.f_148205_, MemoryModuleType.f_26368_, MemoryModuleType.f_26332_, MemoryModuleType.f_26377_, MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, (MemoryModuleType)ABABMemoryModuleTypes.TIME_TRYING_TO_REACH_FETCH_ITEM.get(), MemoryModuleType.f_26335_, MemoryModuleType.f_26370_});
    public static final Collection<? extends SensorType<? extends Sensor<? super Dog>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ABABSensorTypes.ANIMAL_TEMPTATIONS.get()), (Object)SensorType.f_26814_, (Object)SensorType.f_26811_, (Object)SensorType.f_26822_, (Object)((SensorType)ABABSensorTypes.NEAREST_ALLIES.get()), (Object)((SensorType)ABABSensorTypes.DOG_SPECIFIC_SENSOR.get()), (Object)((SensorType)ABABSensorTypes.DOG_VIBRATION_SENSOR.get()), (Object)SensorType.f_26810_, (Object)SensorType.f_26812_);

    public static Optional<InteractionResult> mobInteract(Dog dog, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        Level level = dog.f_19853_;
        if (dog.m_21824_()) {
            if (!(item instanceof DyeItem)) {
                if (DogAi.canBury(stack) && !AiUtil.hasAnyMemory((LivingEntity)dog, (MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get(), MemoryModuleType.f_217770_)) {
                    Optional<BlockPos> digLocation = DigAi.generateDigLocation((PathfinderMob)dog, (Integer)ABABConfig.dogDigMaxXZDistance.get(), (Integer)ABABConfig.dogDigMaxYDistance.get(), bp -> level.m_8055_(bp.m_7495_()).m_204336_(ABABTags.DOG_CAN_DIG));
                    if (digLocation.isPresent()) {
                        CommandAi.yieldAsPet((PathfinderMob)dog);
                        DigAi.setDigLocation((LivingEntity)dog, digLocation.get());
                        ItemStack singleton = stack.m_41620_(1);
                        SharedWolfAi.holdInMouth((Mob)dog, singleton);
                        return Optional.of(InteractionResult.CONSUME);
                    }
                    return Optional.of(InteractionResult.PASS);
                }
                if (dog.m_6898_(stack) && AiUtil.isInjured((LivingEntity)dog)) {
                    dog.m_142075_(player, hand, stack);
                    return Optional.of(InteractionResult.CONSUME);
                }
                return Optional.empty();
            }
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyecolor = dyeItem.m_41089_();
            if (dyecolor != dog.m_30428_()) {
                dog.m_30397_(dyecolor);
                dog.m_142075_(player, hand, stack);
                dog.m_21530_();
                return Optional.of(InteractionResult.CONSUME);
            }
        } else if (dog.m_6898_(stack) && !dog.m_5912_()) {
            dog.m_142075_(player, hand, stack);
            if (MiscUtil.oneInChance(dog.m_217043_(), 3) && !ForgeEventFactory.onAnimalTame((Animal)dog, (Player)player)) {
                SharedWolfAi.tame(dog, player);
                level.m_7605_((Entity)dog, (byte)7);
            } else {
                level.m_7605_((Entity)dog, (byte)6);
            }
            dog.m_21530_();
            return Optional.of(InteractionResult.CONSUME);
        }
        return Optional.empty();
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Dog dog) {
        return dog.m_6274_().m_21968_().map(a -> DogAi.getSoundForActivity(dog, a));
    }

    private static SoundEvent getSoundForActivity(Dog dog, Activity activity) {
        if (activity == Activity.f_37984_) {
            return SoundEvents.f_12621_;
        }
        if (activity == Activity.f_37988_) {
            return SoundEvents.f_12619_;
        }
        if (activity == ABABActivities.HUNT.get()) {
            return null;
        }
        if (activity == Activity.f_37991_ && GenericAi.isNearAvoidTarget((LivingEntity)dog, 6)) {
            return SoundEvents.f_12621_;
        }
        if (activity == Activity.f_37982_) {
            return SoundEvents.f_11950_;
        }
        if (MiscUtil.oneInChance(dog.m_217043_(), 3)) {
            return dog.m_21824_() && dog.m_21223_() < dog.m_21233_() * 0.5f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    public static boolean wantsToPickup(Animal dog, ItemStack stack) {
        return DigAi.getDigLocation((LivingEntity)dog).isEmpty() && SharedWolfAi.isAbleToPickUp((Mob)dog, stack);
    }

    public static void pickUpItem(Dog dog, ItemEntity itemEntity) {
        SharedWolfAi.pickUpAndHoldItem((Mob)dog, itemEntity);
        dog.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.TIME_TRYING_TO_REACH_FETCH_ITEM.get());
    }

    protected static boolean canBury(ItemStack stack) {
        return stack.m_204117_(ABABTags.DOG_BURIES);
    }

    public static boolean isDisliked(LivingEntity livingEntity) {
        return SharedWolfAi.isDisliked(livingEntity, ABABTags.DOG_DISLIKED);
    }

    public static boolean isInteresting(Dog dog, ItemStack stack) {
        return DogAi.canBury(stack) || dog.m_6898_(stack);
    }
}

