/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.illager_hound;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.behavior.long_jump.LeapAtTarget;
import com.infamous.all_bark_all_bite.common.behavior.misc.HurtByEntityTrigger;
import com.infamous.all_bark_all_bite.common.behavior.misc.Sprint;
import com.infamous.all_bark_all_bite.common.behavior.pet.FollowOwner;
import com.infamous.all_bark_all_bite.common.behavior.pet.OwnerHurtByTarget;
import com.infamous.all_bark_all_bite.common.behavior.pet.OwnerHurtTarget;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.illager_hound.IllagerHound;
import com.infamous.all_bark_all_bite.common.util.PetUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class IllagerHoundGoalPackages {
    static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super IllagerHound>>> getCorePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of((Object)new Swim(0.8f), new HurtByEntityTrigger<IllagerHound>(IllagerHoundGoalPackages::onHurtBy), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), new OwnerHurtByTarget(PetUtil::wantsToAttack), new OwnerHurtTarget(PetUtil::wantsToAttack)));
    }

    private static void onHurtBy(IllagerHound victim, LivingEntity attacker) {
        if (Sensor.m_182377_((LivingEntity)victim, (LivingEntity)attacker)) {
            IllagerHoundGoalPackages.retaliate(victim, attacker);
            GenericAi.getNearbyAllies(victim).forEach(nearbyAlly -> IllagerHoundGoalPackages.retaliate(nearbyAlly, attacker));
        }
    }

    private static void retaliate(IllagerHound victim, LivingEntity attacker) {
        if (victim.m_6779_(attacker) && !BehaviorUtils.m_22598_((LivingEntity)victim, (LivingEntity)attacker, (double)4.0)) {
            StartAttacking.m_24213_((Mob)victim, (LivingEntity)attacker);
        }
    }

    static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super IllagerHound>>> getFightPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint(), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.0f), (Object)((Object)new LeapAtTarget(0.4f, 2, 4, SharedWolfAi.LEAP_COOLDOWN)), (Object)new MeleeAttack(20), (Object)new StopAttackingIfTargetInvalid()));
    }

    static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super IllagerHound>>> getIdlePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint(10), new FollowOwner<IllagerHound>(AiUtil::getOwner, 1.0f, 2, 10), (Object)new StartAttacking(IllagerHoundGoalPackages::findNearestValidAttackTarget), IllagerHoundGoalPackages.createIdleLookBehavior(), IllagerHoundGoalPackages.createIdleMovementBehaviors()));
    }

    private static RunSometimes<IllagerHound> createIdleLookBehavior() {
        return new RunSometimes((Behavior)new SetEntityLookTarget(8.0f), UniformInt.m_146622_((int)30, (int)60));
    }

    private static RunOne<IllagerHound> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(IllagerHound illagerHound) {
        Optional nearestAttackablePlayer = illagerHound.m_6274_().m_21952_(MemoryModuleType.f_148206_);
        return nearestAttackablePlayer.isPresent() ? nearestAttackablePlayer : GenericAi.getNearestVisibleLivingEntities((LivingEntity)illagerHound).m_186116_(le -> IllagerHoundGoalPackages.isTargetable(illagerHound, le));
    }

    private static boolean isTargetable(IllagerHound illagerHound, LivingEntity target) {
        EntityType type = target.m_6095_();
        return type.m_204039_(ABABTags.ILLAGER_HOUND_ALWAYS_HOSTILES) && Sensor.m_148312_((LivingEntity)illagerHound, (LivingEntity)target);
    }
}

