/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.wolf;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.entity.AnimalAccess;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABSensorTypes;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.TrustAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class WolfAi {
    public static final Collection<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26355_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_26326_, (Object)((MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.HOWLED_RECENTLY.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get()), (Object[])new MemoryModuleType[]{MemoryModuleType.f_26340_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26374_, MemoryModuleType.f_217781_, (MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_DAY.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get(), MemoryModuleType.f_217768_, (MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_SLEEPING.get(), MemoryModuleType.f_148198_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, (MemoryModuleType)ABABMemoryModuleTypes.LEADER.get(), MemoryModuleType.f_217778_, MemoryModuleType.f_148199_, MemoryModuleType.f_148200_, MemoryModuleType.f_26371_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ADULTS.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_BABIES.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ALLIES.get(), MemoryModuleType.f_148194_, MemoryModuleType.f_148204_, MemoryModuleType.f_26367_, MemoryModuleType.f_26354_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_TARGETABLE_PLAYER_NOT_SNEAKING.get(), MemoryModuleType.f_26331_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ADULTS.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ALLIES.get(), MemoryModuleType.f_148206_, (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABIES.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get(), MemoryModuleType.f_148205_, MemoryModuleType.f_26368_, MemoryModuleType.f_26332_, MemoryModuleType.f_26377_, MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, (MemoryModuleType)ABABMemoryModuleTypes.TRUST.get(), MemoryModuleType.f_26335_, MemoryModuleType.f_26370_, (MemoryModuleType)ABABMemoryModuleTypes.WOLF_VIBRATION_LISTENER.get()});
    public static final Collection<? extends SensorType<? extends Sensor<? super Wolf>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ABABSensorTypes.ANIMAL_TEMPTATIONS.get()), (Object)SensorType.f_26814_, (Object)SensorType.f_26811_, (Object)SensorType.f_26822_, (Object)((SensorType)ABABSensorTypes.NEAREST_ALLIES.get()), (Object)SensorType.f_26810_, (Object)SensorType.f_26812_, (Object)((SensorType)ABABSensorTypes.WOLF_SPECIFIC_SENSOR.get()), (Object)((SensorType)ABABSensorTypes.WOLF_VIBRATION_SENSOR.get()));

    public static Optional<SoundEvent> getSoundForCurrentActivity(Wolf wolf) {
        return wolf.m_6274_().m_21968_().map(a -> WolfAi.getSoundForActivity(wolf, a));
    }

    @Nullable
    private static SoundEvent getSoundForActivity(Wolf wolf, Activity activity) {
        if (activity == Activity.f_37984_) {
            return SoundEvents.f_12621_;
        }
        if (activity == ABABActivities.HUNT.get()) {
            return null;
        }
        if (activity == Activity.f_37988_) {
            return SoundEvents.f_12619_;
        }
        if (activity == Activity.f_37991_ && GenericAi.isNearAvoidTarget((LivingEntity)wolf, 6)) {
            return SoundEvents.f_12621_;
        }
        if (activity == Activity.f_37982_) {
            return SoundEvents.f_11950_;
        }
        if (MiscUtil.oneInChance(wolf.m_217043_(), 3)) {
            return wolf.m_21824_() && wolf.m_21223_() < wolf.m_21233_() * 0.5f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    public static boolean isDisliked(LivingEntity livingEntity) {
        return SharedWolfAi.isDisliked(livingEntity, ABABTags.WOLF_DISLIKED);
    }

    public static boolean isTrusting(Wolf wolf) {
        return wolf.m_21824_() || TrustAi.hasLikedPlayer(wolf);
    }

    public static void initMemories(Wolf wolf, RandomSource random) {
        SharedWolfAi.initMemories(wolf, random);
        int howlCooldownInTicks = SharedWolfAi.TIME_BETWEEN_HOWLS.m_214085_(random);
        SharedWolfAi.setHowledRecently((LivingEntity)wolf, howlCooldownInTicks);
    }

    public static InteractionResult mobInteract(Wolf wolf, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        Item item = itemInHand.m_41720_();
        if (wolf.f_19853_.f_46443_) {
            boolean interact = wolf.m_21830_((LivingEntity)player) && wolf.m_21824_() || itemInHand.m_204117_(ABABTags.WOLF_LOVED) && !wolf.m_21824_() && !wolf.m_21660_();
            return interact ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (wolf.m_21824_()) {
            if (wolf.m_21830_((LivingEntity)player)) {
                Optional<InteractionResult> healInteraction = WolfAi.healInteraction(wolf, player, hand, itemInHand);
                if (healInteraction.isPresent()) {
                    return healInteraction.get();
                }
                if (!(item instanceof DyeItem)) {
                    boolean willNotBreed;
                    InteractionResult animalInteractionResult = AnimalAccess.cast((Animal)wolf).animalInteract(player, hand);
                    if (animalInteractionResult.m_19077_()) {
                        AiUtil.animalEat((Animal)wolf, itemInHand);
                    }
                    boolean bl = willNotBreed = !animalInteractionResult.m_19077_();
                    if (willNotBreed) {
                        SharedWolfAi.manualCommand(wolf, player);
                        return InteractionResult.CONSUME;
                    }
                    return animalInteractionResult;
                }
                DyeItem dyeItem = (DyeItem)item;
                DyeColor dyeColor = dyeItem.m_41089_();
                if (dyeColor != wolf.m_30428_()) {
                    wolf.m_30397_(dyeColor);
                    AnimalAccess.cast((Animal)wolf).takeItemFromPlayer(player, hand, itemInHand);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (TrustAi.isLikedBy(wolf, (LivingEntity)player) && !wolf.m_21660_()) {
            Optional<InteractionResult> healInteraction = WolfAi.healInteraction(wolf, player, hand, itemInHand);
            if (healInteraction.isPresent()) {
                WolfAi.updateTrust(wolf, player);
                return healInteraction.get();
            }
            if (itemInHand.m_204117_(ABABTags.WOLF_LOVED)) {
                AnimalAccess.cast((Animal)wolf).takeItemFromPlayer(player, hand, itemInHand);
                WolfAi.updateTrust(wolf, player);
                return InteractionResult.CONSUME;
            }
        }
        return AnimalAccess.cast((Animal)wolf).animalInteract(player, hand);
    }

    private static void updateTrust(Wolf wolf, Player player) {
        TrustAi.incrementTrust((LivingEntity)wolf, (Integer)ABABConfig.wolfTrustIncrement.get());
        int trust = TrustAi.getTrust((LivingEntity)wolf);
        int maxTrust = (Integer)ABABConfig.wolfMaxTrust.get();
        if (maxTrust > 0 && maxTrust <= trust && !ForgeEventFactory.onAnimalTame((Animal)wolf, (Player)player)) {
            wolf.f_19853_.m_7605_((Entity)wolf, (byte)7);
            SharedWolfAi.tame(wolf, player);
        } else {
            wolf.f_19853_.m_7605_((Entity)wolf, (byte)6);
        }
    }

    private static Optional<InteractionResult> healInteraction(Wolf wolf, Player player, InteractionHand hand, ItemStack itemInHand) {
        if (wolf.m_6898_(itemInHand) && AiUtil.isInjured((LivingEntity)wolf)) {
            AnimalAccess.cast((Animal)wolf).takeItemFromPlayer(player, hand, itemInHand);
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    public static boolean isTargetablePlayerNotSneaking(Wolf wolf, Player player) {
        return !WolfAi.isTrusting(wolf) && AiUtil.isAttackable((Mob)wolf, (LivingEntity)player, true) && AiUtil.isNotCreativeOrSpectator(player) && !player.m_20163_();
    }
}

