/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.wolf;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.behavior.misc.Eat;
import com.infamous.all_bark_all_bite.common.behavior.misc.HurtByTrigger;
import com.infamous.all_bark_all_bite.common.behavior.misc.PerchAndSearch;
import com.infamous.all_bark_all_bite.common.behavior.misc.PickUpItemTrigger;
import com.infamous.all_bark_all_bite.common.behavior.misc.PlayTagWithOtherBabies;
import com.infamous.all_bark_all_bite.common.behavior.misc.Sprint;
import com.infamous.all_bark_all_bite.common.behavior.misc.UpdateUnitMemory;
import com.infamous.all_bark_all_bite.common.behavior.pack.HowlForPack;
import com.infamous.all_bark_all_bite.common.behavior.pack.JoinOrCreatePackAndFollow;
import com.infamous.all_bark_all_bite.common.behavior.pack.ValidateFollowers;
import com.infamous.all_bark_all_bite.common.behavior.pack.ValidateLeader;
import com.infamous.all_bark_all_bite.common.behavior.pet.Beg;
import com.infamous.all_bark_all_bite.common.behavior.sleep.MoveToNonSkySeeingSpot;
import com.infamous.all_bark_all_bite.common.behavior.sleep.WakeUpTrigger;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfBrain;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfAi;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfHooks;
import com.infamous.all_bark_all_bite.common.logic.BrainMaker;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import com.infamous.all_bark_all_bite.common.util.ai.TrustAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.schedule.Activity;

public class WolfBrain {
    public static Brain<Wolf> makeBrain(Brain<Wolf> brain) {
        BrainMaker<Wolf> brainMaker = new BrainMaker<Wolf>(brain);
        brainMaker.initActivityWithConditions(Activity.f_37984_, SharedWolfBrain.getPanicPackage(), SharedWolfBrain.getPanicConditions());
        brainMaker.initActivityWithConditions((Activity)ABABActivities.SIT.get(), SharedWolfBrain.getSitPackage(WolfBrain.createIdleLookBehaviors(), WolfBrain.beg()), SharedWolfBrain.getSitConditions());
        brainMaker.initActivityWithMemoryGate(Activity.f_37988_, SharedWolfBrain.getFightPackage(WolfBrain::isHuntTarget), MemoryModuleType.f_26372_);
        brainMaker.initActivityWithMemoryGate(Activity.f_37991_, SharedWolfBrain.getAvoidPackage(WolfBrain.createIdleMovementBehaviors(), WolfBrain.createIdleLookBehaviors()), MemoryModuleType.f_26383_);
        brainMaker.initActivityWithConditions((Activity)ABABActivities.FOLLOW.get(), SharedWolfBrain.getFollowPackage(WolfBrain.createIdleMovementBehaviors(), WolfBrain.beg(), WolfBrain.createIdleLookBehaviors()), SharedWolfBrain.getFollowConditions());
        brainMaker.initActivityWithMemoryGate(Activity.f_37983_, SharedWolfBrain.getMeetPackage(), (MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get());
        brainMaker.initActivityWithMemoryGate((Activity)ABABActivities.HUNT.get(), SharedWolfBrain.getHuntPackage(), (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get());
        brainMaker.initActivityWithConditions(Activity.f_37982_, SharedWolfBrain.getRestPackage(WolfBrain.createIdleLookBehaviors(), true), SharedWolfBrain.getRestConditions((MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_DAY.get())));
        brainMaker.initActivity(Activity.f_37979_, WolfBrain.getIdlePackage());
        brainMaker.initCoreActivity(Activity.f_37978_, WolfBrain.getCorePackage());
        brainMaker.initCoreActivity((Activity)ABABActivities.COUNT_DOWN.get(), SharedWolfBrain.getCountDownPackage());
        brainMaker.initCoreActivity((Activity)ABABActivities.TARGET.get(), SharedWolfBrain.getTargetPackage(WolfBrain::wasHurtBy, SharedWolfAi::canStartAttacking));
        brainMaker.initCoreActivity((Activity)ABABActivities.UPDATE.get(), SharedWolfBrain.getUpdatePackage(brainMaker.getActivities(), WolfBrain::onActivityChanged));
        return brainMaker.makeBrain(Activity.f_37979_);
    }

    private static RunIf<Wolf> beg() {
        return new RunIf(TamableAnimal::m_21824_, new Beg<Wolf>(Wolf::m_6898_, Wolf::m_30444_, 8.0f), true);
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getCorePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new HurtByTrigger<Wolf>(SharedWolfBrain::onHurtBy), new WakeUpTrigger<Wolf>(SharedWolfAi::wantsToWakeUp), new PickUpItemTrigger<Wolf>(WolfHooks::onWolfPickUpItem), (Object)new Swim(0.8f), SharedWolfBrain.createAnimalPanic(), SharedWolfBrain.createLookAtTargetSink(), SharedWolfBrain.createMoveToTargetSink(), SharedWolfBrain.copyToAvoidTarget((MemoryModuleType<? extends LivingEntity>)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_TARGETABLE_PLAYER_NOT_SNEAKING.get())), SharedWolfBrain.copyToAvoidTarget((MemoryModuleType<? extends LivingEntity>)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get())), new UpdateUnitMemory<Wolf>(TamableAnimal::m_21827_, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get())), new UpdateUnitMemory<Wolf>(SharedWolfAi::hasShelter, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get())), new UpdateUnitMemory<Wolf>(SharedWolfAi::isInDayTime, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_DAY.get())), (Object[])new Behavior[]{new UpdateUnitMemory<Wolf>(WolfBrain::isAlert, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get())), new UpdateUnitMemory<Wolf>(LivingEntity::m_5803_, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_SLEEPING.get())), new ValidateLeader(), new ValidateFollowers()}));
    }

    private static boolean isAlert(Wolf wolf) {
        return SharedWolfAi.alertable(wolf, ABABTags.WOLF_HUNT_TARGETS, ABABTags.WOLF_ALWAYS_HOSTILES, ABABTags.WOLF_DISLIKED);
    }

    private static void wasHurtBy(Wolf wolf, LivingEntity attacker) {
        AiUtil.eraseMemories((LivingEntity)wolf, MemoryModuleType.f_26375_, (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get(), (MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get());
        if (!wolf.m_21824_() && TrustAi.isLikedBy(wolf, attacker)) {
            TrustAi.decrementTrust((LivingEntity)wolf, (Integer)ABABConfig.wolfTrustDecrement.get());
        }
        SharedWolfAi.reactToAttack(wolf, attacker);
    }

    private static void onActivityChanged(Wolf wolf, Pair<Activity, Activity> activityChange) {
        WolfAi.getSoundForCurrentActivity(wolf).ifPresent(se -> AiUtil.playSoundEvent((LivingEntity)wolf, se));
    }

    private static boolean isHuntTarget(Wolf wolf, LivingEntity target) {
        return target.m_6095_().m_204039_(ABABTags.WOLF_HUNT_TARGETS);
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Wolf>>> getIdlePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Wolf>(SharedWolfAi::canMove, 10), (Object)((Object)new Eat(SharedWolfAi::setAteRecently)), (Object)new RunIf(WolfAi::isTrusting, (Behavior)new FollowTemptation(SharedWolfAi::getSpeedModifierTempted), true), (Object)SharedWolfBrain.createBreedBehavior((EntityType<? extends Wolf>)EntityType.f_20499_), (Object)new RunIf(livingEntity -> SharedWolfAi.wantsToFindShelter((LivingEntity)livingEntity, true), (Behavior)new MoveToNonSkySeeingSpot(1.0f), true), new HowlForPack<Wolf>(Predicate.not(TamableAnimal::m_21824_), SharedWolfAi.TIME_BETWEEN_HOWLS, SharedWolfAi.ADULT_FOLLOW_RANGE.m_142737_()), new JoinOrCreatePackAndFollow(SharedWolfAi.ADULT_FOLLOW_RANGE, 1.0f), (Object)new BabyFollowAdult(SharedWolfAi.ADULT_FOLLOW_RANGE, 1.0f), SharedWolfBrain.babySometimesHuntBaby(), (Object)((Object)new PlayTagWithOtherBabies(1.0f, 1.0f)), SharedWolfAi.createGoToWantedItem(false), new PerchAndSearch<Wolf>(SharedWolfBrain::canPerch, TamableAnimal::m_21837_), (Object[])new Behavior[]{WolfBrain.createIdleMovementBehaviors(), WolfBrain.beg(), WolfBrain.createIdleLookBehaviors()}));
    }

    private static RunOne<Wolf> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20499_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<Wolf> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)3), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20499_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)1.0f, (int)2), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }
}

