/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.goal;

import com.infamous.all_bark_all_bite.common.entity.WalkTargetAccess;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MoveToTargetSinkGoal
extends Goal {
    private static final int MAX_COOLDOWN_BEFORE_RETRYING = 40;
    private final PathfinderMob mob;
    private final WalkTargetAccess walkTargetAccess;
    private long lastAttemptTimestamp;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lastTargetPos;
    private float speedModifier;
    private long endTimestamp;

    public MoveToTargetSinkGoal(PathfinderMob mob) {
        this.mob = mob;
        this.walkTargetAccess = WalkTargetAccess.cast(this.mob);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        WalkTarget walkTarget = this.walkTargetAccess.getWalkTarget();
        if (this.mob.m_21691_() || walkTarget == null) {
            return false;
        }
        if (this.lastAttemptTimestamp > this.mob.f_19853_.m_46467_()) {
            return false;
        }
        boolean flag = this.reachedTarget((Mob)this.mob, walkTarget);
        if (!flag && this.tryComputePath(this.mob, walkTarget)) {
            this.lastTargetPos = walkTarget.m_26420_().m_6675_();
            return true;
        }
        this.walkTargetAccess.setWalkTarget(null);
        return false;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, (double)this.speedModifier);
        int duration = 150 + this.mob.m_217043_().m_188503_(101);
        this.endTimestamp = this.mob.f_19853_.m_46467_() + (long)duration;
    }

    public boolean m_8045_() {
        if (this.mob.f_19853_.m_46467_() > this.endTimestamp) {
            return false;
        }
        if (this.path != null && this.lastTargetPos != null) {
            WalkTarget walkTarget = this.walkTargetAccess.getWalkTarget();
            PathNavigation pathNavigation = this.mob.m_21573_();
            return !pathNavigation.m_26571_() && walkTarget != null && !this.reachedTarget((Mob)this.mob, walkTarget);
        }
        return false;
    }

    public void m_8037_() {
        WalkTarget walktarget;
        Path path = this.mob.m_21573_().m_26570_();
        if (this.path != path) {
            this.path = path;
        }
        if (path != null && this.lastTargetPos != null && (walktarget = this.walkTargetAccess.getWalkTarget()) != null && walktarget.m_26420_().m_6675_().m_123331_((Vec3i)this.lastTargetPos) > 4.0 && this.tryComputePath(this.mob, walktarget)) {
            this.lastTargetPos = walktarget.m_26420_().m_6675_();
            this.m_8056_();
        }
    }

    public void m_8041_() {
        WalkTarget walkTarget = this.walkTargetAccess.getWalkTarget();
        if (walkTarget != null && !this.reachedTarget((Mob)this.mob, walkTarget) && this.mob.m_21573_().m_26577_()) {
            this.lastAttemptTimestamp = this.mob.f_19853_.m_46467_() + (long)this.mob.m_217043_().m_188503_(40);
        }
        this.mob.m_21573_().m_26573_();
        this.walkTargetAccess.setWalkTarget(null);
        this.path = null;
    }

    private boolean tryComputePath(PathfinderMob mob, WalkTarget walkTarget) {
        BlockPos targetBlockPos = walkTarget.m_26420_().m_6675_();
        this.path = mob.m_21573_().m_7864_(targetBlockPos, 0);
        this.speedModifier = walkTarget.m_26421_();
        if (this.path != null) {
            return true;
        }
        Vec3 posTowards = DefaultRandomPos.m_148412_((PathfinderMob)mob, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)targetBlockPos), (double)1.5707963705062866);
        if (posTowards != null) {
            this.path = mob.m_21573_().m_26524_(posTowards.f_82479_, posTowards.f_82480_, posTowards.f_82481_, 0);
            return this.path != null;
        }
        return false;
    }

    private boolean reachedTarget(Mob mob, WalkTarget walkTarget) {
        return walkTarget.m_26420_().m_6675_().m_123333_((Vec3i)mob.m_20183_()) <= walkTarget.m_26422_();
    }
}

