/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.logic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class BrainMaker<E extends LivingEntity> {
    private final Brain<E> brain;
    private final Map<Activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>>> coreActivities = Maps.newHashMap();
    private final List<Activity> activities = new ArrayList<Activity>();

    public BrainMaker(Brain<E> brain) {
        this.brain = brain;
    }

    public void initCoreActivity(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> behaviors) {
        this.coreActivities.put(activity, behaviors);
        this.coreActivities.forEach((arg_0, arg_1) -> this.brain.m_21900_(arg_0, arg_1));
    }

    public void initActivity(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> behaviors) {
        this.activities.add(activity);
        this.brain.m_21900_(activity, behaviors);
    }

    public void initActivityWithConditions(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> behaviors, Set<Pair<MemoryModuleType<?>, MemoryStatus>> entryCondtion) {
        this.activities.add(activity);
        this.brain.m_21903_(activity, behaviors, entryCondtion);
    }

    public void initActivityWithMemoryGate(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> behaviors, MemoryModuleType<?> memory) {
        this.activities.add(activity);
        this.brain.m_21907_(activity, behaviors, (Set)ImmutableSet.of((Object)Pair.of(memory, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of(memory));
    }

    public void initActivityWithConditionsAndRemovals(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> behaviors, Set<Pair<MemoryModuleType<?>, MemoryStatus>> entryCondtion, Set<MemoryModuleType<?>> exitErasedMemories) {
        this.activities.add(activity);
        this.brain.m_21907_(activity, behaviors, entryCondtion, exitErasedMemories);
    }

    public void setDefaultActivity(Activity activity) {
        this.brain.m_21944_(activity);
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public Brain<E> makeBrain(Activity defaultActivity) {
        this.brain.m_21930_(this.coreActivities.keySet());
        this.brain.m_21944_(defaultActivity);
        this.brain.m_21962_();
        return this.brain;
    }
}

