/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.logic;

import com.google.common.collect.Maps;
import com.infamous.all_bark_all_bite.common.logic.entity_manager.MultiEntityManager;
import com.infamous.all_bark_all_bite.common.util.PetUtil;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class PetManagement {
    private static final Map<ResourceKey<Level>, Map<UUID, MultiEntityManager>> BY_LEVEL_BY_OWNER = Maps.newHashMap();

    private static void tick(ServerLevel level) {
        BY_LEVEL_BY_OWNER.values().forEach(byOwner -> byOwner.forEach((ownerUUID, petManager) -> petManager.tick(level, entity -> PetManagement.isValidPet(ownerUUID, entity))));
    }

    private static boolean isValidPet(UUID ownerUUID, Entity entity) {
        return PetUtil.getOwnerUUID(entity).filter(uuid -> uuid.equals(ownerUUID)).isPresent();
    }

    public static MultiEntityManager getPetManager(ResourceKey<Level> dimension, UUID ownerUUID) {
        return BY_LEVEL_BY_OWNER.computeIfAbsent(dimension, k -> Maps.newHashMap()).computeIfAbsent(ownerUUID, k -> new MultiEntityManager(Collections.emptyList()));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="all_bark_all_bite")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Level level = event.getLevel();
            if (!level.f_46443_) {
                Entity entity = event.getEntity();
                PetUtil.getOwnerUUID(entity).ifPresent(uuid -> PetManagement.getPetManager((ResourceKey<Level>)level.m_46472_(), uuid).add(entity));
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            Level level = event.getLevel();
            if (!level.f_46443_) {
                UUID playerUUID = player.m_20148_();
                PetUtil.getOwnerUUID(target).filter(uuid -> uuid.equals(playerUUID)).ifPresent(uuid -> PetManagement.getPetManager((ResourceKey<Level>)level.m_46472_(), uuid).add(target));
            }
        }

        @SubscribeEvent
        static void onServerTick(TickEvent.LevelTickEvent event) {
            Level level = event.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (event.phase == TickEvent.Phase.END) {
                    PetManagement.tick(serverLevel);
                }
            }
        }
    }
}

