/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.logic.entity_manager;

import com.infamous.all_bark_all_bite.common.logic.entity_manager.TickableEntityManager;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class SingleEntityManager
implements TickableEntityManager {
    private static final int CONVERSION_DELAY = MiscUtil.seconds(2.0);
    private int conversionDelay = Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)0, (int)CONVERSION_DELAY);
    @Nullable
    private Entity entity;
    @Nullable
    private UUID entityUuid;

    public static Codec<SingleEntityManager> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216157_.optionalFieldOf("uuid").forGetter(SingleEntityManager::getEntityUUID)).apply((Applicative)instance, uuid -> new SingleEntityManager(uuid.orElse(null))));
    }

    public SingleEntityManager() {
    }

    public SingleEntityManager(@Nullable UUID entityUuid) {
        this.entityUuid = entityUuid;
    }

    public Optional<UUID> getEntityUUID() {
        return Optional.ofNullable(this.entity != null ? this.entity.m_20148_() : this.entityUuid);
    }

    @Override
    public void tick(ServerLevel level, Predicate<Entity> isValid, Consumer<Entity> onInvalid) {
        --this.conversionDelay;
        if (this.conversionDelay <= 0) {
            this.convertFromUuid(level);
            this.conversionDelay = CONVERSION_DELAY;
        }
        if (this.entity != null) {
            boolean isRemoved;
            Entity.RemovalReason removalReason = this.entity.m_146911_();
            boolean valid = isValid.test(this.entity);
            boolean bl = isRemoved = removalReason != null;
            if (!valid || isRemoved) {
                if (!valid) {
                    onInvalid.accept(this.entity);
                }
                if (isRemoved) {
                    switch (removalReason) {
                        case CHANGED_DIMENSION: 
                        case UNLOADED_TO_CHUNK: 
                        case UNLOADED_WITH_PLAYER: {
                            this.entityUuid = this.entity.m_20148_();
                        }
                    }
                }
                this.entity = null;
            }
        }
    }

    private void convertFromUuid(ServerLevel level) {
        Entity entity;
        if (this.entityUuid != null && (entity = level.m_8791_(this.entityUuid)) != null) {
            this.entity = entity;
            this.entityUuid = null;
        }
    }

    public boolean hasEntity() {
        return this.entity != null || this.entityUuid != null;
    }

    public Optional<Entity> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    public void set(Entity entity) {
        this.entity = entity;
        this.entityUuid = null;
    }

    public void erase() {
        this.entity = null;
        this.entityUuid = null;
    }
}

