/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.sensor;

import com.google.common.collect.ImmutableSet;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.entity.dog.DogAi;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class DogSpecificSensor
extends Sensor<Dog> {
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_148205_, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get()), (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26354_);
    }

    protected void doTick(ServerLevel level, Dog dog) {
        boolean tame = dog.m_21824_();
        Brain<Dog> brain = dog.m_6274_();
        Optional<Object> nearestDisliked = Optional.empty();
        Optional<Object> nearestHuntable = Optional.empty();
        Optional<Object> nearestAttackable = Optional.empty();
        Optional<Object> nearestPlayerHoldingWantedItem = Optional.empty();
        NearestVisibleLivingEntities nvle = brain.m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
        for (LivingEntity livingEntity : nvle.m_186123_(le -> true)) {
            if (nearestDisliked.isEmpty() && !tame && DogAi.isDisliked(livingEntity)) {
                nearestDisliked = Optional.of(livingEntity);
                continue;
            }
            if (nearestHuntable.isEmpty() && !tame && DogSpecificSensor.isHuntable(dog, livingEntity)) {
                nearestHuntable = Optional.of(livingEntity);
                continue;
            }
            if (nearestAttackable.isEmpty() && DogSpecificSensor.isAttackable(dog, livingEntity)) {
                nearestAttackable = Optional.of(livingEntity);
                continue;
            }
            if (!(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            if (!nearestPlayerHoldingWantedItem.isEmpty() || player.m_5833_() || !player.m_21093_(is -> DogAi.isInteresting(dog, is))) continue;
            nearestPlayerHoldingWantedItem = Optional.of(player);
        }
        brain.m_21886_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get(), nearestDisliked);
        brain.m_21886_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get(), nearestHuntable);
        brain.m_21886_(MemoryModuleType.f_148194_, nearestAttackable);
        brain.m_21886_(MemoryModuleType.f_26354_, nearestPlayerHoldingWantedItem);
    }

    private static boolean isAttackable(Dog dog, LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(ABABTags.DOG_ALWAYS_HOSTILES) && AiUtil.isClose((Mob)dog, livingEntity, (Integer)ABABConfig.dogTargetDetectionDistance.get()) && AiUtil.isAttackable((Mob)dog, livingEntity, true) && SharedWolfAi.wantsToAttack(dog, livingEntity);
    }

    private static boolean isHuntable(Dog dog, LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(ABABTags.DOG_HUNT_TARGETS) && AiUtil.isClose((Mob)dog, livingEntity, (Integer)ABABConfig.dogTargetDetectionDistance.get()) && AiUtil.isAttackable((Mob)dog, livingEntity, true) && SharedWolfAi.wantsToAttack(dog, livingEntity);
    }
}

