/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.structure;

import com.infamous.all_bark_all_bite.AllBarkAllBite;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import com.infamous.all_bark_all_bite.mixin.StructureTemplatePoolAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="all_bark_all_bite")
public class StructurePieceAppender {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    private static void addStructurePieceToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = processorListRegistry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            ((StructureTemplatePoolAccessor)pool).getTemplates().add((Object)piece);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)pool).getRawTemplates());
        listOfPieceEntries.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
        ((StructureTemplatePoolAccessor)pool).setRawTemplates(listOfPieceEntries);
    }

    @SubscribeEvent
    static void addStructurePieces(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).orElseThrow();
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "black");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "blue");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "brown");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "cream");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "gold");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "gray");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "red");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "white");
        StructurePieceAppender.addDogToCatPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "yellow");
        StructurePieceAppender.addKennelToOutpostPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry);
    }

    private static void addKennelToOutpostPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        StructurePieceAppender.addStructureToPools((List)ABABConfig.kennelTemplatePoolTargets.get(), templatePoolRegistry, processorListRegistry, "pillager_outpost/feature_kennel", 1);
    }

    private static void addStructureToPools(List<? extends String> pools, Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String path, int weight) {
        for (String string : pools) {
            StructurePieceAppender.tryMakeRL(string).ifPresentOrElse(poolRL -> StructurePieceAppender.addPieceToPool(templatePoolRegistry, processorListRegistry, path, poolRL, weight), () -> AllBarkAllBite.LOGGER.error("Unable to parse structure template pool {}, make sure it uses the \"namespace:path\" format.", (Object)pool));
        }
    }

    private static Optional<ResourceLocation> tryMakeRL(String string) {
        return Optional.ofNullable(ResourceLocation.m_135820_((String)string));
    }

    private static void addDogToCatPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String variant) {
        StructurePieceAppender.addStructureToPools((List)ABABConfig.dogTemplatePoolTargets.get(), templatePoolRegistry, processorListRegistry, String.format("%s_%s", "village/common/animals/dog", variant), 1);
    }

    private static void addPieceToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String path, ResourceLocation poolRL, int weight) {
        String nbtPieceRL = new ResourceLocation("all_bark_all_bite", path).toString();
        AllBarkAllBite.LOGGER.info("Adding structure piece {} to structure template pool {} with weight {}", new Object[]{nbtPieceRL, poolRL, weight});
        StructurePieceAppender.addStructurePieceToPool(templatePoolRegistry, processorListRegistry, poolRL, nbtPieceRL, weight);
    }
}

