/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class DebugUtil {
    private static void sendCustomPayloadPacketToAllPlayers(ServerLevel level, FriendlyByteBuf friendlyByteBuf, ResourceLocation location) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(location, friendlyByteBuf);
        for (ServerPlayer player : level.m_6907_()) {
            player.f_8906_.m_9829_((Packet)packet);
        }
    }

    public static void sendEntityBrain(LivingEntity livingEntity, ServerLevel level, MemoryModuleType<?> ... memoriesToCheck) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        DebugUtil.writeBrain(livingEntity, byteBuf, memoriesToCheck);
        DebugUtil.sendCustomPayloadPacketToAllPlayers(level, byteBuf, ClientboundCustomPayloadPacket.f_132023_);
    }

    private static void writeBrain(LivingEntity livingEntity, FriendlyByteBuf byteBuf, MemoryModuleType<?> ... memoriesToCheck) {
        Brain brain = livingEntity.m_6274_();
        long gameTime = livingEntity.f_19853_.m_46467_();
        DebugUtil.writeBrainDumpArguments(livingEntity, byteBuf, brain, gameTime);
        DebugUtil.writeBrainDumpAdditional(livingEntity, byteBuf, brain, gameTime, memoriesToCheck);
    }

    private static void writeBrainDumpArguments(LivingEntity livingEntity, FriendlyByteBuf byteBuf, Brain<?> brain, long gameTime) {
        DebugUtil.writePos(livingEntity, byteBuf);
        byteBuf.m_130077_(livingEntity.m_20148_());
        byteBuf.writeInt(livingEntity.m_19879_());
        byteBuf.m_130070_(DebugEntityNameGenerator.m_179486_((Entity)livingEntity));
        DebugUtil.writeProfession(livingEntity, byteBuf);
        DebugUtil.writeXp(livingEntity, byteBuf);
        byteBuf.writeFloat(livingEntity.m_21223_());
        byteBuf.writeFloat(livingEntity.m_21233_());
        DebugUtil.writeInventory(livingEntity, byteBuf);
        DebugUtil.writePath(byteBuf, brain);
        DebugUtil.writeWantsGolem(livingEntity, byteBuf, gameTime);
        DebugUtil.writerAngerLevel(livingEntity, byteBuf);
    }

    private static void writePos(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        Vec3 position = livingEntity.m_20182_();
        byteBuf.writeDouble(position.f_82479_);
        byteBuf.writeDouble(position.f_82480_);
        byteBuf.writeDouble(position.f_82481_);
    }

    private static void writeProfession(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            byteBuf.m_130070_(villager.m_7141_().m_35571_().f_35600_());
        } else {
            byteBuf.m_130070_("");
        }
    }

    private static void writeXp(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            byteBuf.writeInt(villager.m_7809_());
        } else {
            byteBuf.writeInt(0);
        }
    }

    private static void writeInventory(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        if (livingEntity instanceof InventoryCarrier) {
            InventoryCarrier inventoryCarrier = (InventoryCarrier)livingEntity;
            SimpleContainer container = inventoryCarrier.m_35311_();
            byteBuf.m_130070_(container.m_7983_() ? "" : container.toString());
        } else {
            byteBuf.m_130070_("");
        }
    }

    private static void writePath(FriendlyByteBuf byteBuf, Brain<?> brain) {
        byteBuf.writeBoolean(false);
    }

    private static void writeBrainDumpAdditional(LivingEntity livingEntity, FriendlyByteBuf byteBuf, Brain<?> brain, long gameTime, MemoryModuleType<?> ... memoriesToCheck) {
        DebugUtil.writeActivities(byteBuf, brain);
        DebugUtil.writeBehaviors(byteBuf, brain);
        DebugUtil.writeMemories(livingEntity, byteBuf, gameTime, memoriesToCheck);
        DebugUtil.writePois(livingEntity, byteBuf, brain);
        DebugUtil.writePotentialPois(livingEntity, byteBuf, brain);
        DebugUtil.writeGossips(livingEntity, byteBuf);
    }

    private static void writeActivities(FriendlyByteBuf byteBuf, Brain<?> brain) {
        byteBuf.m_236828_((Collection)brain.m_147340_(), (fbb, a) -> fbb.m_130070_(a.m_37998_()));
    }

    private static void writeBehaviors(FriendlyByteBuf byteBuf, Brain<?> brain) {
        Set runningBehaviors = brain.m_21956_().stream().map(Behavior::toString).collect(Collectors.toSet());
        byteBuf.m_236828_(runningBehaviors, FriendlyByteBuf::m_130070_);
    }

    private static void writeMemories(LivingEntity livingEntity, FriendlyByteBuf byteBuf, long gameTime, MemoryModuleType<?> ... memoriesToCheck) {
        byteBuf.m_236828_(DebugUtil.getMemoryDescriptions(livingEntity, gameTime, memoriesToCheck), (fbb, s) -> {
            String truncatedString = StringUtil.m_144998_((String)s, (int)255, (boolean)true);
            fbb.m_130070_(truncatedString);
        });
    }

    private static void writeGossips(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            Map gossipEntries = villager.m_35517_().m_148159_();
            ArrayList gossips = Lists.newArrayList();
            gossipEntries.forEach((uuid, gossipEntry) -> {
                String s = DebugEntityNameGenerator.m_133668_((UUID)uuid);
                gossipEntry.forEach((gossipType, integer) -> gossips.add(s + ": " + gossipType + ": " + integer));
            });
            byteBuf.m_236828_((Collection)gossips, FriendlyByteBuf::m_130070_);
        } else {
            byteBuf.m_130130_(0);
        }
    }

    private static void writePotentialPois(LivingEntity livingEntity, FriendlyByteBuf byteBuf, Brain<?> brain) {
        if (livingEntity instanceof Villager) {
            Set secondaryPositionMemories = Stream.of(MemoryModuleType.f_26361_).map(arg_0 -> brain.m_21952_(arg_0)).flatMap(Optional::stream).map(GlobalPos::m_122646_).collect(Collectors.toSet());
            byteBuf.m_236828_(secondaryPositionMemories, FriendlyByteBuf::m_130064_);
        } else {
            byteBuf.m_130130_(0);
        }
    }

    private static void writePois(LivingEntity livingEntity, FriendlyByteBuf byteBuf, Brain<?> brain) {
        if (livingEntity instanceof Villager) {
            Set pois = Stream.of(MemoryModuleType.f_26360_, MemoryModuleType.f_26359_, MemoryModuleType.f_26362_).map(arg_0 -> brain.m_21952_(arg_0)).flatMap(Optional::stream).map(GlobalPos::m_122646_).collect(Collectors.toSet());
            byteBuf.m_236828_(pois, FriendlyByteBuf::m_130064_);
        } else {
            byteBuf.m_130130_(0);
        }
    }

    private static void writerAngerLevel(LivingEntity livingEntity, FriendlyByteBuf byteBuf) {
        if (livingEntity instanceof Warden) {
            Warden warden = (Warden)livingEntity;
            byteBuf.writeInt(warden.m_219464_());
        } else {
            byteBuf.writeInt(-1);
        }
    }

    private static void writeWantsGolem(LivingEntity livingEntity, FriendlyByteBuf byteBuf, long gameTime) {
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            boolean wantsToSpawnGolem = villager.m_35392_(gameTime);
            byteBuf.writeBoolean(wantsToSpawnGolem);
        } else {
            byteBuf.writeBoolean(false);
        }
    }

    private static List<String> getMemoryDescriptions(LivingEntity livingEntity, long gameTime, MemoryModuleType<?> ... memoriesToCheck) {
        Map memories = livingEntity.m_6274_().m_147339_();
        ArrayList memoryDescriptions = Lists.newArrayList();
        if (memoriesToCheck.length > 0) {
            for (MemoryModuleType<?> memory : memoriesToCheck) {
                Optional memoryValue = memories.getOrDefault(memory, Optional.empty());
                DebugUtil.addMemoryDescription(memoryDescriptions, livingEntity, gameTime, memory, memoryValue);
            }
        } else {
            for (Map.Entry entry : memories.entrySet()) {
                MemoryModuleType memory = (MemoryModuleType)entry.getKey();
                Optional memoryValue = (Optional)entry.getValue();
                DebugUtil.addMemoryDescription(memoryDescriptions, livingEntity, gameTime, memory, memoryValue);
            }
        }
        memoryDescriptions.sort(String::compareTo);
        return memoryDescriptions;
    }

    private static void addMemoryDescription(List<String> memoryDescriptions, LivingEntity livingEntity, long gameTime, MemoryModuleType<?> memoryModuleType, Optional<? extends ExpirableValue<?>> memoryValue) {
        Object memory;
        if (memoryValue.isPresent()) {
            ExpirableValue<?> expirableValue = memoryValue.get();
            Object value = expirableValue.m_26319_();
            if (value instanceof Long) {
                Long recordedTime = (Long)value;
                long duration = gameTime - recordedTime;
                memory = duration + " ticks ago";
            } else {
                memory = expirableValue.m_26321_() ? DebugUtil.getShortDescription((ServerLevel)livingEntity.f_19853_, value) + " (ttl: " + expirableValue.m_148191_() + ")" : DebugUtil.getShortDescription((ServerLevel)livingEntity.f_19853_, value);
            }
        } else {
            memory = "-";
        }
        memoryDescriptions.add(ForgeRegistries.MEMORY_MODULE_TYPES.getKey(memoryModuleType).m_135815_() + ": " + (String)memory);
    }

    private static String getShortDescription(ServerLevel level, @Nullable Object value) {
        if (value == null) {
            return "-";
        }
        if (value instanceof UUID) {
            return DebugUtil.getShortDescription(level, level.m_8791_((UUID)value));
        }
        if (value instanceof LivingEntity) {
            Entity entity1 = (Entity)value;
            return DebugEntityNameGenerator.m_179486_((Entity)entity1);
        }
        if (value instanceof Nameable) {
            return ((Nameable)value).m_7755_().getString();
        }
        if (value instanceof WalkTarget) {
            return DebugUtil.getShortDescription(level, ((WalkTarget)value).m_26420_());
        }
        if (value instanceof EntityTracker) {
            return DebugUtil.getShortDescription(level, ((EntityTracker)value).m_147481_());
        }
        if (value instanceof GlobalPos) {
            return DebugUtil.getShortDescription(level, ((GlobalPos)value).m_122646_());
        }
        if (value instanceof BlockPosTracker) {
            return DebugUtil.getShortDescription(level, ((BlockPosTracker)value).m_6675_());
        }
        if (value instanceof EntityDamageSource) {
            Entity entity = ((EntityDamageSource)value).m_7639_();
            return entity == null ? value.toString() : DebugUtil.getShortDescription(level, entity);
        }
        if (!(value instanceof Collection)) {
            return value.toString();
        }
        Collection collection = (Collection)value;
        ArrayList list = Lists.newArrayList();
        for (Object listValue : collection) {
            list.add(DebugUtil.getShortDescription(level, listValue));
        }
        return ((Object)list).toString();
    }
}

