/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.infamous.all_bark_all_bite.common.logic.MobInteraction;
import com.infamous.all_bark_all_bite.mixin.LivingEntityAccessor;
import com.infamous.all_bark_all_bite.mixin.MobAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class AiUtil {
    public static final float DEFAULT_FALL_REDUCTION = 3.0f;
    private static final TargetingConditions TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
    private static final TargetingConditions TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT_IGNORE_INVISIBILITY_TESTING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
    public static final double NEAR_ZERO_DELTA_MOVEMENT = 1.0E-6;

    public static void addEatEffect(LivingEntity eater, Level level, FoodProperties foodProperties) {
        for (Pair pair : foodProperties.m_38749_()) {
            if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
            eater.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
        }
    }

    public static boolean hasAnyMemory(LivingEntity livingEntity, MemoryModuleType<?> ... memoryModuleTypes) {
        Brain brain = livingEntity.m_6274_();
        for (MemoryModuleType<?> memoryModuleType : memoryModuleTypes) {
            if (!brain.m_21874_(memoryModuleType)) continue;
            return true;
        }
        return false;
    }

    public static void eraseMemories(LivingEntity livingEntity, MemoryModuleType<?> ... memoryModuleTypes) {
        Brain brain = livingEntity.m_6274_();
        for (MemoryModuleType<?> memoryModuleType : memoryModuleTypes) {
            brain.m_21936_(memoryModuleType);
        }
    }

    public static boolean isClose(Mob mob, LivingEntity target, int closeEnough) {
        return target.m_20280_((Entity)mob) <= (double)Mth.m_144944_((int)closeEnough);
    }

    public static boolean isAttackable(Mob mob, LivingEntity target, boolean requireLineOfSight) {
        return requireLineOfSight ? Sensor.m_148312_((LivingEntity)mob, (LivingEntity)target) : Sensor.m_182377_((LivingEntity)mob, (LivingEntity)target);
    }

    public static boolean isHuntableBabyTurtle(Mob mob, LivingEntity target, int closeEnough, boolean requireLineOfSight) {
        Turtle turtle;
        return AiUtil.isClose(mob, target, closeEnough) && target instanceof Turtle && Turtle.f_30122_.test(turtle = (Turtle)target) && AiUtil.isAttackable(mob, (LivingEntity)turtle, requireLineOfSight);
    }

    public static boolean isSameTypeAndFriendly(LivingEntity mob, LivingEntity other) {
        return mob.m_6095_() == other.m_6095_() && (mob.m_7307_((Entity)other) || mob.m_5647_() == null && other.m_5647_() == null);
    }

    public static Optional<LivingEntity> getLivingEntityFromUUID(ServerLevel level, UUID uuid) {
        return Optional.of(uuid).map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    public static boolean isLookingAtMe(LivingEntity me, LivingEntity target, double offset) {
        Vec3 viewVector = target.m_20252_(1.0f).m_82541_();
        Vec3 eyeToMyEyeVector = target.m_146892_().m_82505_(me.m_146892_());
        double distance = eyeToMyEyeVector.m_82553_();
        double dot = viewVector.m_82526_(eyeToMyEyeVector = eyeToMyEyeVector.m_82541_());
        return dot > 1.0 - offset / distance && target.m_142582_((Entity)me);
    }

    public static <T extends Mob> InteractionResult interactOn(Player player, T entity, InteractionHand hand, MobInteraction<T> mobInteraction) {
        ItemStack itemInHand = player.m_21120_(hand);
        ItemStack itemInHandCopy = itemInHand.m_41777_();
        InteractionResult interactionResult = AiUtil.interact(entity, player, hand, mobInteraction);
        if (interactionResult.m_19077_()) {
            if (player.m_150110_().f_35937_ && itemInHand == player.m_21120_(hand) && itemInHand.m_41613_() < itemInHandCopy.m_41613_()) {
                itemInHand.m_41764_(itemInHandCopy.m_41613_());
            }
            if (!player.m_150110_().f_35937_ && itemInHand.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemInHandCopy, (InteractionHand)hand);
            }
            return interactionResult;
        }
        if (!itemInHand.m_41619_()) {
            InteractionResult livingEntityInteractionResult;
            if (player.m_150110_().f_35937_) {
                itemInHand = itemInHandCopy;
            }
            if ((livingEntityInteractionResult = itemInHand.m_41647_(player, entity, hand)).m_19077_()) {
                if (itemInHand.m_41619_() && !player.m_150110_().f_35937_) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemInHandCopy, (InteractionHand)hand);
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                return livingEntityInteractionResult;
            }
        }
        return InteractionResult.PASS;
    }

    private static <T extends Mob> InteractionResult interact(T mob, Player player, InteractionHand hand, MobInteraction<T> mobInteraction) {
        if (!mob.m_6084_()) {
            return InteractionResult.PASS;
        }
        if (mob.m_21524_() == player) {
            mob.m_21455_(true, !player.m_150110_().f_35937_);
            return InteractionResult.m_19078_((boolean)mob.f_19853_.f_46443_);
        }
        InteractionResult interactionResult = ((MobAccessor)mob).callCheckAndHandleImportantInteractions(player, hand);
        if (interactionResult != null && interactionResult.m_19077_()) {
            return interactionResult;
        }
        interactionResult = mobInteraction.apply(mob, player, hand);
        if (interactionResult.m_19077_()) {
            mob.m_146850_(GameEvent.f_223708_);
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    public static boolean isInjured(LivingEntity livingEntity) {
        return livingEntity.m_21223_() < livingEntity.m_21233_();
    }

    public static void animalEat(Animal animal, ItemStack stack) {
        if (animal.m_6898_(stack) && !animal.f_19853_.f_46443_) {
            AiUtil.playSoundEvent((LivingEntity)animal, animal.m_7866_(stack));
            float healAmount = 1.0f;
            FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)animal);
            if (foodProperties != null) {
                healAmount = foodProperties.m_38744_();
                AiUtil.addEatEffect((LivingEntity)animal, animal.f_19853_, foodProperties);
            }
            if (AiUtil.isInjured((LivingEntity)animal)) {
                animal.m_5634_(healAmount);
            }
            animal.m_8035_();
        }
    }

    public static void playSoundEvent(LivingEntity livingEntity, SoundEvent soundEvent) {
        livingEntity.m_5496_(soundEvent, AiUtil.getSoundVolume(livingEntity), livingEntity.m_6100_());
    }

    public static void setWalkAndLookTargetMemories(LivingEntity mob, Entity target, float speedModifier, int closeEnough) {
        EntityTracker lookTarget = new EntityTracker(target, true);
        WalkTarget walkTarget = new WalkTarget(target, speedModifier, closeEnough);
        mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)lookTarget);
        mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)walkTarget);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity mob, BlockPos target, float speedModifier, int closeEnough) {
        BlockPosTracker lookTarget = new BlockPosTracker(target);
        WalkTarget walkTarget = new WalkTarget(target, speedModifier, closeEnough);
        mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)lookTarget);
        mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)walkTarget);
    }

    public static boolean onCheckCooldown(ServerLevel level, long lastCheckTimestamp, long checkCooldown) {
        long ticksSinceLastCheck = level.m_46467_() - lastCheckTimestamp;
        return lastCheckTimestamp != 0L && ticksSinceLastCheck > 0L && ticksSinceLastCheck < checkCooldown;
    }

    public static void setItemPickupCooldown(LivingEntity mob, int itemPickupCooldownTicks) {
        mob.m_6274_().m_21879_(MemoryModuleType.f_217781_, (Object)itemPickupCooldownTicks);
    }

    public static Optional<LivingEntity> getLivingEntityFromId(Level level, int id) {
        return Optional.ofNullable(level.m_6815_(id)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    public static Optional<LivingEntity> getOwner(OwnableEntity ownableEntity) {
        return Optional.ofNullable(ownableEntity.m_21826_()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    public static Optional<LivingEntity> getTarget(LivingEntity livingEntity) {
        Optional<Object> optional;
        if (livingEntity.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            optional = livingEntity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        } else {
            LivingEntity livingEntity2;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                livingEntity2 = mob.m_5448_();
            } else {
                livingEntity2 = null;
            }
            optional = Optional.ofNullable(livingEntity2);
        }
        return optional;
    }

    public static Optional<Entity> getTargetedEntity(Entity looker, int distance) {
        int distanceSquared;
        AABB searchBox;
        Vec3 viewVector;
        Vec3 targetPosition;
        Vec3 eyePosition = looker.m_146892_();
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)looker, (Vec3)eyePosition, (Vec3)(targetPosition = eyePosition.m_82549_(viewVector = looker.m_20252_(1.0f).m_82490_((double)distance))), (AABB)(searchBox = looker.m_20191_().m_82369_(viewVector).m_82400_(1.0)), AiUtil::canHitEntity, (double)(distanceSquared = distance * distance));
        if (entityHitResult == null) {
            return Optional.empty();
        }
        return eyePosition.m_82557_(entityHitResult.m_82450_()) > (double)distanceSquared ? Optional.empty() : Optional.of(entityHitResult.m_82443_());
    }

    private static boolean canHitEntity(Entity entity) {
        return !entity.m_5833_() && entity.m_6087_();
    }

    public static HitResult getHitResult(Entity looker, int distance) {
        int distanceSquared;
        AABB searchBox;
        EntityHitResult entityHitResult;
        Vec3 viewVector;
        Vec3 targetPosition;
        Vec3 eyePosition = looker.m_146892_();
        BlockHitResult hitResult = looker.f_19853_.m_45547_(new ClipContext(eyePosition, targetPosition = eyePosition.m_82549_(viewVector = looker.m_20252_(1.0f).m_82490_((double)distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, looker));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            targetPosition = hitResult.m_82450_();
        }
        if ((entityHitResult = ProjectileUtil.m_37287_((Entity)looker, (Vec3)eyePosition, (Vec3)targetPosition, (AABB)(searchBox = looker.m_20191_().m_82369_(viewVector).m_82400_(1.0)), AiUtil::canHitEntity, (double)(distanceSquared = distance * distance))) != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    public static void sendEatParticles(ServerLevel level, LivingEntity entity, ItemStack itemstack) {
        if (!itemstack.m_41619_()) {
            Vec3 dist = new Vec3(((double)entity.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), entity.m_20185_() + entity.m_20154_().f_82479_ / 2.0, entity.m_20186_(), entity.m_20189_() + entity.m_20154_().f_82481_ / 2.0, 10, dist.f_82479_, dist.f_82480_ + 0.05, dist.f_82481_, 0.0);
        }
    }

    public static float getSoundVolume(LivingEntity livingEntity) {
        return ((LivingEntityAccessor)livingEntity).callGetSoundVolume();
    }

    private static boolean isMovingOnLand(LivingEntity entity) {
        return entity.m_20096_() && AiUtil.isMoving(entity) && !entity.m_20072_();
    }

    private static boolean isMoving(LivingEntity entity) {
        return entity.m_20184_().m_165925_() > 1.0E-6;
    }

    private static boolean isMovingInWater(LivingEntity entity) {
        return entity.m_20072_() && AiUtil.isMoving(entity);
    }

    public static boolean isMovingOnLandOrInWater(LivingEntity entity) {
        return (entity.m_20096_() || entity.m_20072_()) && AiUtil.isMoving(entity);
    }

    public static boolean isEntityTargetableIgnoringLineOfSight(LivingEntity entity, LivingEntity target) {
        return entity.m_6274_().m_21938_(MemoryModuleType.f_26372_, (Object)target) ? TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT_IGNORE_INVISIBILITY_TESTING.m_26885_(entity, target) : TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.m_26885_(entity, target);
    }

    public static boolean isPathClear(LivingEntity entity, LivingEntity target, int horizontalDistance, int verticalDistance) {
        double zDiff = target.m_20189_() - entity.m_20189_();
        double xDiff = target.m_20185_() - entity.m_20185_();
        double ratio = zDiff / xDiff;
        for (int horizontalStep = 0; horizontalStep < horizontalDistance; ++horizontalStep) {
            double zStep = ratio == 0.0 ? 0.0 : zDiff * (double)((float)horizontalStep / (float)horizontalDistance);
            double xStep = ratio == 0.0 ? xDiff * (double)((float)horizontalStep / (float)horizontalDistance) : zStep / ratio;
            for (int verticalStep = 1; verticalStep < verticalDistance + 1; ++verticalStep) {
                if (entity.f_19853_.m_8055_(new BlockPos(entity.m_20185_() + xStep, entity.m_20186_() + (double)verticalStep, entity.m_20189_() + zStep)).m_60767_().m_76336_()) continue;
                return false;
            }
        }
        return true;
    }

    public static void dropItemAtPos(LivingEntity entity, BlockPos blockPos, ItemStack itemStack) {
        ItemEntity drop = new ItemEntity(entity.f_19853_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123342_(), itemStack);
        entity.f_19853_.m_7967_((Entity)drop);
    }

    public static double getFollowRange(LivingEntity mob) {
        return mob.m_21133_(Attributes.f_22277_);
    }

    public static boolean isNotCreativeOrSpectator(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static void resetPose(LivingEntity entity, Pose currentPose) {
        if (entity.m_217003_(currentPose)) {
            entity.m_20124_(Pose.STANDING);
        }
    }

    public static boolean isTiredOfTryingToReachTarget(LivingEntity mob, long timeout) {
        Optional cantReachWalkTargetSince = mob.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        return cantReachWalkTargetSince.isPresent() && mob.f_19853_.m_46467_() - (Long)cantReachWalkTargetSince.get() > timeout;
    }
}

