/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.infamous.all_bark_all_bite.common.util.ReflectionUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class BrainUtil {
    private static final String GATE_BEHAVIOR_BEHAVIORS = "f_22871_";
    private static final String BRAIN_AVAILABLE_BEHAVIORS_BY_PRIORITY = "f_21845_";
    private static final String BRAIN_SENSORS = "f_21844_";

    public static <T extends LivingEntity> Brain<T> getTypedBrain(T mob) {
        return mob.m_6274_();
    }

    public static <E extends LivingEntity> Map<Integer, Map<Activity, Set<Behavior<? super E>>>> getAvailableBehaviorsByPriority(Brain<E> brain) {
        return (Map)ReflectionUtil.getField(BRAIN_AVAILABLE_BEHAVIORS_BY_PRIORITY, Brain.class, brain);
    }

    public static <E extends LivingEntity> ShufflingList<Behavior<? super E>> getGateBehaviors(GateBehavior<E> gateBehavior) {
        return (ShufflingList)ReflectionUtil.getField(GATE_BEHAVIOR_BEHAVIORS, GateBehavior.class, gateBehavior);
    }

    public static <E extends LivingEntity> ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> createPriorityPairs(int priorityStart, ImmutableList<? extends Behavior<? super E>> behaviors) {
        int i = priorityStart;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Behavior behavior : behaviors) {
            builder.add((Object)Pair.of((Object)i++, (Object)behavior));
        }
        return builder.build();
    }

    public static <E extends LivingEntity> GateBehavior<E> tryAllBehaviorsInOrderIfAbsent(List<Behavior<? super E>> behaviors, MemoryModuleType<?> ... entryTypes) {
        ImmutableMap.Builder entryConditions = ImmutableMap.builder();
        for (MemoryModuleType<?> type : entryTypes) {
            entryConditions.put(type, (Object)MemoryStatus.VALUE_ABSENT);
        }
        return new GateBehavior((Map)entryConditions.build(), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, BrainUtil.basicWeightedBehaviors(behaviors));
    }

    private static <E extends LivingEntity> ImmutableList<Pair<Behavior<? super E>, Integer>> basicWeightedBehaviors(List<Behavior<? super E>> behaviors) {
        ImmutableList.Builder weightedBehaviors = ImmutableList.builder();
        for (Behavior<E> behavior : behaviors) {
            weightedBehaviors.add((Object)Pair.of(behavior, (Object)1));
        }
        return weightedBehaviors.build();
    }

    public static <E extends LivingEntity> Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> getSensors(Brain<E> brain) {
        return (Map)ReflectionUtil.getField(BRAIN_SENSORS, Brain.class, brain);
    }
}

