/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.infamous.all_bark_all_bite.common.behavior.pet.FollowOwner;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.common.compat.DICompat;
import com.infamous.all_bark_all_bite.common.compat.MMCompat;
import com.infamous.all_bark_all_bite.common.entity.LookTargetAccess;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.WalkTargetAccess;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.PetUtil;
import com.infamous.all_bark_all_bite.common.util.ReflectionUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class CommandAi {
    private static final String FOX_CLEAR_STATES = "m_28569_";

    public static void yieldAsPet(PathfinderMob pathfinderMob) {
        CommandAi.yieldAsPet(pathfinderMob, Activity.f_37979_);
    }

    public static void yieldAsPet(PathfinderMob pathfinderMob, Activity activity) {
        pathfinderMob.m_6274_().m_21889_(activity);
        AiUtil.setItemPickupCooldown((LivingEntity)pathfinderMob, 60);
        AiUtil.eraseMemories((LivingEntity)pathfinderMob, MemoryModuleType.f_26334_, MemoryModuleType.f_26335_);
        pathfinderMob.m_6862_(false);
        GenericAi.stopWalking(pathfinderMob);
        pathfinderMob.m_6710_(null);
    }

    public static void commandAttack(PathfinderMob pet, LivingEntity target, LivingEntity owner) {
        CommandAi.handleStates(pet, false, true);
        CommandAi.yieldAsPet(pet);
        if (pet.m_6779_(target) && PetUtil.wantsToAttack((LivingEntity)pet, target, owner)) {
            StartAttacking.m_24213_((Mob)pet, (LivingEntity)target);
            pet.m_6710_(target);
        }
    }

    public static void commandCome(PathfinderMob pet, LivingEntity owner, ServerLevel serverLevel) {
        CommandAi.handleStates(pet, false, true);
        CommandAi.yieldAsPet(pet);
        if (pet.m_19950_((Entity)owner, (double)((Integer)ABABConfig.petTeleportDistanceTrigger.get()).intValue())) {
            CommandAi.navigateToTarget(pet, owner, 1.0f);
        } else {
            FollowOwner.teleportToEntity(owner, serverLevel, pet, pet instanceof FlyingAnimal);
        }
    }

    public static void commandFree(PathfinderMob pet, LivingEntity user) {
        CommandAi.commandFree(pet, user, true);
    }

    public static void commandFree(PathfinderMob pet, LivingEntity user, boolean handleDI) {
        if (CompatUtil.isDILoaded() && handleDI) {
            DICompat.setDICommand((Entity)pet, user, 0);
        }
        CommandAi.handleStates(pet, false, true);
        CommandAi.yieldAsPet(pet);
        CommandAi.release((LivingEntity)pet);
        CommandAi.resetFollowTriggerDistance((LivingEntity)pet);
    }

    public static void commandFollow(PathfinderMob pet, LivingEntity user) {
        CommandAi.commandFollow(pet, user, true);
    }

    public static void commandFollow(PathfinderMob pet, LivingEntity user, boolean handleDI) {
        if (CompatUtil.isDILoaded() && handleDI) {
            DICompat.setDICommand((Entity)pet, user, 2);
        }
        CommandAi.handleStates(pet, false, true);
        CommandAi.resetFollowTriggerDistance((LivingEntity)pet);
        CommandAi.orderToFollow((LivingEntity)pet);
        CommandAi.yieldAsPet(pet, (Activity)ABABActivities.FOLLOW.get());
    }

    public static void commandGo(PathfinderMob pet, LivingEntity user, HitResult hitResult) {
        CommandAi.handleStates(pet, false, true);
        CommandAi.yieldAsPet(pet);
        CommandAi.release((LivingEntity)pet);
        CommandAi.resetFollowTriggerDistance((LivingEntity)pet);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            CommandAi.navigateToTarget(pet, blockHitResult.m_82425_(), 1.0f);
        } else if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            CommandAi.navigateToTarget(pet, entityHitResult.m_82443_(), 1.0f);
        }
    }

    public static void commandHeel(PathfinderMob pet, LivingEntity user) {
        if (CompatUtil.isDILoaded()) {
            DICompat.setDICommand((Entity)pet, user, 2);
        }
        CommandAi.handleStates(pet, false, true);
        CommandAi.orderToFollow((LivingEntity)pet);
        CommandAi.yieldAsPet(pet, (Activity)ABABActivities.FOLLOW.get());
        CommandAi.setHeeling((LivingEntity)pet);
    }

    public static void commandSit(PathfinderMob pet, LivingEntity user) {
        CommandAi.commandSit(pet, user, true);
    }

    public static void commandSit(PathfinderMob pet, LivingEntity user, boolean handleDI) {
        if (CompatUtil.isDILoaded() && handleDI) {
            DICompat.setDICommand((Entity)pet, user, 1);
        }
        CommandAi.handleStates(pet, true, false);
        pet.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get(), (Object)Unit.INSTANCE);
        CommandAi.yieldAsPet(pet, (Activity)ABABActivities.SIT.get());
    }

    private static void navigateToTarget(PathfinderMob mob, Object target, float speedModifier) {
        if (mob.m_6274_().m_21876_(MemoryModuleType.f_26370_, MemoryStatus.REGISTERED)) {
            if (target instanceof Entity) {
                Entity entity = (Entity)target;
                AiUtil.setWalkAndLookTargetMemories((LivingEntity)mob, entity, speedModifier, 0);
            } else if (target instanceof BlockPos) {
                BlockPos blockPos = (BlockPos)target;
                AiUtil.setWalkAndLookTargetMemories((LivingEntity)mob, blockPos, speedModifier, 0);
            }
        } else if (target instanceof Entity || target instanceof BlockPos) {
            BlockPosTracker lookTarget;
            WalkTarget walkTarget;
            if (target instanceof Entity) {
                Entity entity = (Entity)target;
                walkTarget = new WalkTarget(entity, speedModifier, 0);
            } else {
                BlockPos blockPos = (BlockPos)target;
                walkTarget = new WalkTarget(blockPos, speedModifier, 0);
            }
            if (target instanceof Entity) {
                Entity entity = (Entity)target;
                lookTarget = new EntityTracker(entity, true);
            } else {
                BlockPos blockPos = (BlockPos)target;
                lookTarget = new BlockPosTracker(blockPos);
            }
            WalkTargetAccess.cast(mob).setWalkTarget(walkTarget);
            LookTargetAccess.cast(mob).setLookTarget((PositionTracker)lookTarget);
        }
    }

    private static void handleStates(PathfinderMob pet, boolean orderedToSit, boolean resetSit) {
        if (pet instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)pet;
            tamableAnimal.m_21839_(orderedToSit);
            if (CompatUtil.isMMLoaded()) {
                MMCompat.setRodlingSitting(tamableAnimal, orderedToSit);
            }
            SharedWolfAi.clearStates(tamableAnimal, resetSit);
        } else if (pet instanceof Fox) {
            Fox fox = (Fox)pet;
            ReflectionUtil.callMethod(FOX_CLEAR_STATES, fox, new Object[0]);
        }
    }

    public static void orderToFollow(LivingEntity entity) {
        entity.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get(), (Object)Unit.INSTANCE);
    }

    public static void release(LivingEntity entity) {
        entity.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get());
    }

    public static boolean isOrderedToFollow(LivingEntity entity) {
        return entity.m_6274_().m_21874_((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get());
    }

    public static void setHeeling(LivingEntity entity) {
        entity.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get(), (Object)2);
    }

    public static void resetFollowTriggerDistance(LivingEntity entity) {
        entity.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get(), (Object)10);
    }

    public static int getFollowTriggerDistance(LivingEntity entity) {
        return (Integer)entity.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get()).get();
    }
}

