/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ReflectionUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GenericAi {
    private static final String FOX_SET_SLEEPING = "m_28626_";

    public static <E extends LivingEntity> List<E> getNearbyAdults(E ageableMob) {
        return (List)ageableMob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ADULTS.get()).orElse(ImmutableList.of());
    }

    public static <E extends LivingEntity> List<E> getNearbyVisibleAdults(E ageableMob) {
        return (List)ageableMob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ADULTS.get()).orElse(ImmutableList.of());
    }

    public static <E extends LivingEntity> List<E> getNearbyAllies(E ageableMob) {
        return (List)ageableMob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_ALLIES.get()).orElse(ImmutableList.of());
    }

    public static <E extends LivingEntity> List<E> getNearbyVisibleAllies(E ageableMob) {
        return (List)ageableMob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ALLIES.get()).orElse(ImmutableList.of());
    }

    public static <E extends LivingEntity> List<E> getNearestVisibleBabies(E ageableMob) {
        return (List)ageableMob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_BABIES.get()).orElse(ImmutableList.of());
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21952_(MemoryModuleType.f_148206_);
    }

    public static void stopWalking(PathfinderMob pathfinderMob) {
        pathfinderMob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        pathfinderMob.m_21573_().m_26573_();
    }

    public static Optional<LivingEntity> getAttackTarget(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
    }

    public static void setAvoidTarget(LivingEntity livingEntity, LivingEntity target, int avoidTimeInTicks) {
        AiUtil.eraseMemories(livingEntity, MemoryModuleType.f_26372_, MemoryModuleType.f_26370_);
        livingEntity.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)avoidTimeInTicks);
    }

    public static boolean isNearAvoidTarget(LivingEntity livingEntity, int desiredDistanceFromAvoidTarget) {
        return GenericAi.isNearTarget(livingEntity, desiredDistanceFromAvoidTarget, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.f_26383_);
    }

    public static boolean isNearTarget(LivingEntity livingEntity, int closeEnough, MemoryModuleType<? extends LivingEntity> targetMemory) {
        Brain brain = livingEntity.m_6274_();
        return brain.m_21874_(targetMemory) && ((LivingEntity)brain.m_21952_(targetMemory).get()).m_19950_((Entity)livingEntity, (double)closeEnough);
    }

    public static Vec3 getRandomNearbyPos(PathfinderMob pathfinderMob, int maxXZDistance, int maxYDistance) {
        Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)pathfinderMob, (int)maxXZDistance, (int)maxYDistance);
        return pos == null ? pathfinderMob.m_20182_() : pos;
    }

    public static boolean seesPlayerHoldingWantedItem(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21874_(MemoryModuleType.f_26354_);
    }

    public static void wakeUp(LivingEntity mob) {
        if (mob instanceof Fox) {
            Fox fox = (Fox)mob;
            ReflectionUtil.callMethod(FOX_SET_SLEEPING, fox, false);
        }
        mob.m_5796_();
        mob.m_6274_().m_21879_(MemoryModuleType.f_26329_, (Object)mob.f_19853_.m_46467_());
    }

    public static void goToSleep(LivingEntity mob) {
        if (mob instanceof Fox) {
            Fox fox = (Fox)mob;
            ReflectionUtil.callMethod(FOX_SET_SLEEPING, fox, true);
        }
        mob.m_5802_(mob.m_20183_());
        mob.m_6274_().m_21879_(MemoryModuleType.f_26328_, (Object)mob.f_19853_.m_46467_());
        mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
    }

    public static NearestVisibleLivingEntities getNearestVisibleLivingEntities(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }

    public static List<LivingEntity> getNearestLivingEntities(LivingEntity livingEntity) {
        return (List)livingEntity.m_6274_().m_21952_(MemoryModuleType.f_148204_).orElse(ImmutableList.of());
    }

    public static Optional<WalkTarget> getWalkTarget(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21952_(MemoryModuleType.f_26370_);
    }

    public static boolean isPanicking(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21874_(MemoryModuleType.f_217768_);
    }

    public static boolean isOnPickupCooldown(LivingEntity livingEntity) {
        return livingEntity.m_6274_().m_21874_(MemoryModuleType.f_217781_);
    }

    public static void broadcastAttackTarget(List<? extends Mob> alertables, LivingEntity target) {
        alertables.forEach(alertable -> GenericAi.setAttackTargetIfCloserThanCurrent(alertable, target));
    }

    public static void setAttackTargetIfCloserThanCurrent(Mob mob, LivingEntity target) {
        Optional attackTarget = mob.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        LivingEntity nearestTarget = BehaviorUtils.m_22625_((LivingEntity)mob, (Optional)attackTarget, (LivingEntity)target);
        StartAttacking.m_24213_((Mob)mob, (LivingEntity)nearestTarget);
    }

    public static Optional<Player> getTemptingPlayer(PathfinderMob mob) {
        return mob.m_6274_().m_21952_(MemoryModuleType.f_148196_);
    }
}

