/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class HunterAi {
    public static boolean hasAnyoneNearbyHuntedRecently(LivingEntity mob, List<? extends LivingEntity> nearby) {
        return HunterAi.hasHuntedRecently(mob) || nearby.stream().anyMatch(HunterAi::hasHuntedRecently);
    }

    public static boolean hasHuntedRecently(LivingEntity mob) {
        return mob.m_6274_().m_21874_(MemoryModuleType.f_26340_);
    }

    public static void setHuntedRecently(LivingEntity mob, int huntCooldownInTicks) {
        mob.m_6274_().m_21882_(MemoryModuleType.f_26340_, (Object)true, (long)huntCooldownInTicks);
    }

    public static void broadcastHuntedRecently(UniformInt huntCooldown, List<? extends LivingEntity> alertables) {
        alertables.forEach(alertable -> HunterAi.setHuntedRecently(alertable, huntCooldown.m_214085_(alertable.m_217043_())));
    }

    public static Optional<LivingEntity> getNearestVisibleHuntable(LivingEntity mob) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get());
    }

    public static Optional<LivingEntity> getHuntTarget(LivingEntity mob) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get());
    }

    public static void stopHunting(LivingEntity mob) {
        mob.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get());
    }

    public static void broadcastHuntTarget(List<? extends LivingEntity> alertables, LivingEntity target) {
        alertables.forEach(alertable -> HunterAi.setHuntTargetIfCloserThanCurrent(alertable, target));
    }

    private static void setHuntTargetIfCloserThanCurrent(LivingEntity mob, LivingEntity target) {
        Optional huntTarget = mob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get());
        LivingEntity nearestTarget = BehaviorUtils.m_22625_((LivingEntity)mob, (Optional)huntTarget, (LivingEntity)target);
        HunterAi.setHuntTarget(mob, nearestTarget);
    }

    public static void setHuntTarget(LivingEntity mob, LivingEntity target) {
        mob.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get(), (Object)target);
    }
}

