/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.google.common.collect.Lists;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LongJumpAi {
    public static final List<Integer> ALLOWED_ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});

    @Nullable
    public static Vec3 calculateOptimalJumpVector(Mob mob, Vec3 targetPos, double maxJumpVelocity, List<Integer> allowedAnglesIn) {
        ArrayList allowedAngles = Lists.newArrayList(allowedAnglesIn);
        Collections.shuffle(allowedAngles);
        Iterator iterator = allowedAngles.iterator();
        while (iterator.hasNext()) {
            int allowedAngle = (Integer)iterator.next();
            Vec3 jumpVectorForAngle = LongJumpAi.calculateJumpVectorForAngle(mob, targetPos, allowedAngle, maxJumpVelocity);
            if (jumpVectorForAngle == null) continue;
            return jumpVectorForAngle;
        }
        return null;
    }

    @Nullable
    public static Vec3 calculateJumpVectorForAngle(Mob mob, Vec3 targetPos, int angle, double maxJumpVelocity) {
        Vec3 startPos = mob.m_20182_();
        Vec3 horizontalDiff = targetPos.m_82492_(startPos.f_82479_, targetPos.f_82480_, startPos.f_82481_).m_82541_().m_82490_(0.5);
        targetPos = targetPos.m_82546_(horizontalDiff);
        Vec3 initialVector = targetPos.m_82546_(startPos);
        float radians = (float)angle * (float)Math.PI / 180.0f;
        double theta = Math.atan2(initialVector.f_82481_, initialVector.f_82479_);
        double horizontalDistanceSqr = initialVector.m_165925_();
        double horizontalDistance = Math.sqrt(horizontalDistanceSqr);
        double initialY = initialVector.f_82480_;
        double d4 = Math.sin(2.0f * radians);
        double d5 = 0.08;
        double cosSquared = Mth.m_144952_((double)Math.cos(radians));
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        double zScale = Math.sin(theta);
        double xScale = Math.cos(theta);
        double jumpVelocitySqr = horizontalDistanceSqr * 0.08 / (horizontalDistance * d4 - 2.0 * initialY * cosSquared);
        if (jumpVelocitySqr < 0.0) {
            return null;
        }
        double jumpVelocity = Math.sqrt(jumpVelocitySqr);
        if (jumpVelocity > maxJumpVelocity) {
            return null;
        }
        double xzD = jumpVelocity * cos;
        double yD = jumpVelocity * sin;
        int numJumpSteps = Mth.m_14165_((double)(horizontalDistance / xzD)) * 2;
        double d15 = 0.0;
        Vec3 prevJumpStep = null;
        for (int jumpStepIndex = 0; jumpStepIndex < numJumpSteps - 1; ++jumpStepIndex) {
            double yShift = sin / cos * (d15 += horizontalDistance / (double)numJumpSteps) - Mth.m_144952_((double)d15) * 0.08 / (2.0 * jumpVelocitySqr * Mth.m_144952_((double)cos));
            double xShift = d15 * xScale;
            double zShift = d15 * zScale;
            Vec3 nextJumpStep = startPos.m_82520_(xShift, yShift, zShift);
            if (prevJumpStep != null && !LongJumpAi.isClearTransition(mob, prevJumpStep, nextJumpStep)) {
                return null;
            }
            prevJumpStep = nextJumpStep;
        }
        return new Vec3(xzD * xScale, yD, xzD * zScale).m_82490_((double)0.95f);
    }

    public static boolean isClearTransition(Mob mob, Vec3 from, Vec3 to) {
        EntityDimensions longJumpingDimensions = mob.m_6972_(Pose.LONG_JUMPING);
        Vec3 diff = to.m_82546_(from);
        double d0 = Math.min(longJumpingDimensions.f_20377_, longJumpingDimensions.f_20378_);
        int numSteps = Mth.m_14165_((double)(diff.m_82553_() / d0));
        Vec3 normDiff = diff.m_82541_();
        Vec3 step = from;
        for (int stepIndex = 0; stepIndex < numSteps; ++stepIndex) {
            step = stepIndex == numSteps - 1 ? to : step.m_82549_(normDiff.m_82490_(d0 * (double)0.9f));
            AABB boundingBox = longJumpingDimensions.m_20393_(step);
            if (mob.f_19853_.m_45756_((Entity)mob, boundingBox)) continue;
            return false;
        }
        return true;
    }

    public static Optional<PositionTracker> getLongJumpTarget(LivingEntity mob) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.LONG_JUMP_TARGET.get());
    }

    public static void setLongJumpTarget(LivingEntity mob, PositionTracker target) {
        mob.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.LONG_JUMP_TARGET.get(), (Object)target);
    }

    public static void clearLongJumpTarget(LivingEntity mob) {
        mob.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.LONG_JUMP_TARGET.get());
    }

    public static boolean isMidJump(LivingEntity mob) {
        return mob.m_6274_().m_21874_(MemoryModuleType.f_148200_);
    }

    public static void setMidJump(LivingEntity mob) {
        mob.m_6274_().m_21879_(MemoryModuleType.f_148200_, (Object)true);
    }

    public static void clearMidJump(LivingEntity mob) {
        mob.m_6274_().m_21936_(MemoryModuleType.f_148200_);
    }

    public static boolean isOnJumpCooldown(LivingEntity wolf) {
        return wolf.m_6274_().m_21874_(MemoryModuleType.f_148199_);
    }

    public static void setLongJumpCooldown(LivingEntity mob, int cooldownTicks) {
        mob.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)cooldownTicks);
    }
}

