/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.vibration;

import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.registry.ABABGameEvents;
import com.infamous.all_bark_all_bite.common.sensor.vibration.EntityVibrationListenerConfig;
import com.infamous.all_bark_all_bite.common.util.ai.PackAi;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.jetbrains.annotations.Nullable;

public abstract class SharedWolfVibrationListenerConfig<T extends Wolf>
extends EntityVibrationListenerConfig<T> {
    @Override
    protected boolean shouldEntityListen(ServerLevel level, GameEventListener gameEventListener, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
        if (!((Wolf)this.entity).m_21525_() && !((Wolf)this.entity).m_21224_() && level.m_6857_().m_61937_(blockPos) && !((Wolf)this.entity).m_213877_() && ((Wolf)this.entity).m_9236_() == level) {
            Optional<GlobalPos> howlLocation = SharedWolfAi.getHowlLocation(this.entity);
            if (howlLocation.isEmpty()) {
                return true;
            }
            GlobalPos howlPos = howlLocation.get();
            return howlPos.m_122640_().equals((Object)level.m_46472_()) && howlPos.m_122646_().equals((Object)blockPos);
        }
        return false;
    }

    @Override
    protected void onEntityReceiveSignal(ServerLevel level, GameEventListener gameEventListener, BlockPos signalPos, GameEvent signalEvent, @Nullable Entity signalSender, @Nullable Entity signalSenderOwner, float signalDistance) {
        if (signalEvent == ABABGameEvents.ENTITY_HOWL.get() && signalSender != this.entity && signalSender instanceof LivingEntity) {
            LivingEntity howler = (LivingEntity)signalSender;
            if (!this.wantsToRespond(howler)) {
                return;
            }
            if (this.canTreatAsFollower(howler)) {
                this.respondToHowl(true);
            } else if (this.isFollowerOf(howler)) {
                SharedWolfAi.followHowl((Wolf)this.entity, signalPos);
                this.respondToHowl(false);
            } else if (this.canJoinOrCreatePackWith(howler)) {
                SharedWolfAi.followHowl((Wolf)this.entity, signalPos);
                this.respondToHowl(false);
            }
        }
    }

    private boolean wantsToRespond(LivingEntity other) {
        return !((Wolf)this.entity).m_19950_((Entity)other, (double)SharedWolfAi.ADULT_FOLLOW_RANGE.m_142737_()) && !((Wolf)this.entity).m_21824_();
    }

    private boolean canJoinOrCreatePackWith(LivingEntity other) {
        return PackAi.isLoner(this.entity) && (PackAi.canAddToFollowers(other, this.entity) || PackAi.isLoner(other));
    }

    private boolean isFollowerOf(LivingEntity other) {
        return PackAi.isFollower(this.entity) && PackAi.getLeaderUUID(this.entity).get().equals(other.m_20148_());
    }

    private boolean canTreatAsFollower(LivingEntity other) {
        return PackAi.hasFollowers(this.entity) && (this.isLeaderOf(other) || PackAi.canAddToFollowers(this.entity, other));
    }

    private boolean isLeaderOf(LivingEntity other) {
        return PackAi.isFollower(other) && PackAi.getLeaderUUID(other).get().equals(((Wolf)this.entity).m_20148_());
    }

    private void respondToHowl(boolean ignoreCooldown) {
        if (!SharedWolfAi.hasHowledRecently(this.entity) || ignoreCooldown) {
            SharedWolfAi.howl(this.entity);
            SharedWolfAi.setHowledRecently(this.entity, SharedWolfAi.TIME_BETWEEN_HOWLS.m_214085_(((Wolf)this.entity).m_217043_()));
        }
    }
}

