/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.mixin;

import com.infamous.all_bark_all_bite.common.entity.AnimalAccess;
import com.infamous.all_bark_all_bite.common.entity.AnimationControllerAccess;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAnimationController;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfHooks;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimal
implements AnimalAccess,
AnimationControllerAccess<SharedWolfAnimationController> {
    private SharedWolfAnimationController animationController;

    protected WolfMixin(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void handleInit(EntityType<?> entityType, Level level, CallbackInfo ci) {
        this.animationController = new SharedWolfAnimationController(this, (EntityDataAccessor<Byte>)TamableAnimal.f_21798_, (EntityDataAccessor<Pose>)Entity.f_19806_);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (this.animationController != null) {
            this.animationController.onSyncedDataUpdatedAnimations(entityDataAccessor);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void handleTick(CallbackInfo ci) {
        this.animationController.tickAnimations();
    }

    @Inject(method={"aiStep"}, at={@At(value="RETURN")})
    private void handleAiStep(CallbackInfo ci) {
        this.animationController.aiStepAnimations();
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")})
    private void handleDoHurtTarget(Entity target, CallbackInfoReturnable<Boolean> cir) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
    }

    @Inject(method={"setTame"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetTame(boolean tame, CallbackInfo ci) {
        super.m_7105_(tame);
        ci.cancel();
    }

    @Inject(method={"canMate"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCanMate(Animal partner, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)WolfHooks.canWolfMate((Wolf)this, partner));
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleGetAmbientSound(CallbackInfoReturnable<SoundEvent> cir) {
        cir.setReturnValue((Object)WolfHooks.getWolfAmbientSound((Wolf)this));
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleHandleEntityEvent(byte id, CallbackInfo ci) {
        this.animationController.handleEntityEventAnimation(id);
    }

    @Override
    public InteractionResult animalInteract(Player player, InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    @Override
    public void takeItemFromPlayer(Player player, InteractionHand hand, ItemStack itemStack) {
        AiUtil.animalEat((Animal)this, itemStack);
        this.m_142075_(player, hand, itemStack);
    }

    @Override
    public SharedWolfAnimationController getAnimationController() {
        return this.animationController;
    }
}

