/*
 * Decompiled with CFR 0.152.
 */
package baguchan.armored_redstone.entity;

import baguchan.armored_redstone.ArmoredRedstone;
import baguchan.armored_redstone.entity.BaseArmorEntity;
import baguchan.armored_redstone.message.ArmorAttackMessage;
import baguchan.armored_redstone.message.FireArmorStopAttackMessage;
import baguchan.armored_redstone.register.ModDamageSource;
import baguchan.armored_redstone.register.ModKeyMappings;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class FireArmorEntity
extends BaseArmorEntity {
    private static final EntityDataAccessor<Boolean> DATA_FIRE_ATTACK = SynchedEntityData.m_135353_(FireArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FireArmorEntity(EntityType<? extends FireArmorEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FIRE_ATTACK, (Object)false);
    }

    @Override
    public boolean healItem(ItemStack itemstack) {
        return itemstack.m_150930_(Items.f_42417_);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
        if (DATA_FIRE_ATTACK.equals(p_21104_)) {
            if (this.isFireAttack()) {
                this.attackFinishedAnimationState.m_216977_(this.f_19797_);
                this.attackAnimationState.m_216973_();
            } else {
                this.attackAnimationState.m_216977_(this.f_19797_);
                this.attackFinishedAnimationState.m_216973_();
            }
        }
    }

    @Override
    public void attack() {
        this.setFireAttack(true);
    }

    @Override
    public void secondAttack() {
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isFireAttack()) {
            this.addFireParticle();
            this.fireAttack();
            this.m_146850_(GameEvent.f_157778_);
        }
    }

    public void fireAttack() {
        for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.getFireBoundingBox())) {
            if (entity == this || this.m_146895_() != null && (this.m_146895_() == null || entity == this.m_146895_()) || this.m_7307_(entity) || !entity.m_6097_() || !((double)this.m_20270_(entity) < 26.0)) continue;
            if (entity instanceof LivingEntity && this.m_146895_() instanceof Player) {
                ((LivingEntity)entity).m_6598_((Player)this.m_146895_());
            }
            entity.m_20254_(8);
            entity.m_6469_(ModDamageSource.fire(this, this.m_146895_()), 8.0f);
        }
        this.m_5496_(SoundEvents.f_11874_, this.m_217043_().m_188501_() * 0.5f, this.m_217043_().m_188501_() * 0.5f);
    }

    public AABB getFireBoundingBox() {
        Vec3 vec3d = this.m_20252_(1.0f);
        return this.m_20191_().m_82310_(0.0, (double)(-(this.m_20206_() - this.m_20205_())), 0.0).m_82363_(vec3d.f_82479_ * 4.0, vec3d.f_82480_ * 4.0, vec3d.f_82481_ * 4.0).m_82386_(vec3d.f_82479_ * 1.6, vec3d.f_82480_ * 1.6, vec3d.f_82481_ * 1.6);
    }

    public void addFireParticle() {
        double dist = 1.5;
        for (int i2 = 0; i2 < 2; ++i2) {
            Vec3 look = this.m_20154_();
            float f14 = this.m_146908_() * ((float)Math.PI / 180);
            float f2 = Mth.m_14031_((float)f14);
            float f15 = Mth.m_14089_((float)f14);
            float direct = i2 == 0 ? -1.0f : 1.0f;
            double px = this.m_20185_() + (double)(f15 * 1.4f * direct) + look.m_7096_() * dist;
            double py = this.m_20186_() + (double)this.m_20192_() + look.m_7098_() * dist;
            double pz = this.m_20189_() + (double)(f2 * 1.4f * direct) + look.m_7094_() * dist;
            for (int i = 0; i < 2; ++i) {
                double dx = look.m_7096_();
                double dy = look.m_7098_();
                double dz = look.m_7094_();
                double spread = 5.0 + this.m_217043_().m_188500_() * 2.5;
                double velocity = 0.2 + this.m_217043_().m_188500_() * 0.15;
                dx += this.m_217043_().m_188583_() * 0.0075 * spread;
                dy += this.m_217043_().m_188583_() * 0.0075 * spread;
                dz += this.m_217043_().m_188583_() * 0.0075 * spread;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        super.updateClientControls();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && this.m_20363_((Entity)mc.f_91074_)) {
            if (ModKeyMappings.keyFire.m_90857_()) {
                this.attackingStart();
            } else if (this.isFireAttack()) {
                ArmoredRedstone.CHANNEL.sendToServer((Object)new FireArmorStopAttackMessage((Entity)this));
            }
        } else if (this.isFireAttack()) {
            ArmoredRedstone.CHANNEL.sendToServer((Object)new FireArmorStopAttackMessage((Entity)this));
        }
    }

    public void setFireAttack(boolean attack) {
        this.f_19804_.m_135381_(DATA_FIRE_ATTACK, (Object)attack);
    }

    public boolean isFireAttack() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FIRE_ATTACK);
    }

    private void attackingStart() {
        ArmoredRedstone.CHANNEL.sendToServer((Object)new ArmorAttackMessage((Entity)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), (double)0.1f).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0);
    }
}

