/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class SonicShockEffect
extends ChargedAbilityEffect {
    public static final SonicShockEffect instance = new SonicShockEffect();

    public SonicShockEffect() {
        super(60, 0.15, 450, 1.0, EffectGuiStats.sonicShockEffect, ChargedAbilityEffect.TargetRequirement.either, UseAnim.SPEAR, "raised");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.sonicShockEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.sonic_shock.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger("art_of_forging.effect.sonic_shock.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!target.f_19853_.f_46443_) {
            int level = item.getEffectLevel(itemStack, EffectGuiStats.sonicShockEffect);
            AbilityUseResult result = this.doSonicBoomAttack(level, attacker, item, itemStack, target);
            attacker.m_21011_(hand, false);
            attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
            item.tickProgression((LivingEntity)attacker, itemStack, 1);
            item.applyDamage(10, itemStack, (LivingEntity)attacker);
        }
    }

    private AbilityUseResult doSonicBoomAttack(float damage, Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 0.0, 1.0, 1.0f, 1.0f);
        ServerLevel world = (ServerLevel)attacker.f_19853_;
        if (result != AbilityUseResult.fail) {
            Vec3 vec3 = attacker.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
            Vec3 vec31 = target.m_146892_().m_82546_(vec3);
            Vec3 vec32 = vec31.m_82541_();
            for (int i = 1; i < Mth.m_14107_((double)vec31.m_82553_()) + 7; ++i) {
                Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)i));
                world.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 3.0f, 1.0f);
            target.m_6469_(DamageSource.m_216876_((Entity)attacker), damage);
            double d1 = 0.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            double d0 = 2.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            target.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
        }
        return result;
    }
}

