/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.common.entity.projectile.DragonFruit;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class DragonRootsBlock
extends BushBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DragonRootsStage> TOP_STAGE = EnumProperty.m_61587_((String)"top", DragonRootsStage.class);
    public static final EnumProperty<DragonRootsStage> BOTTOM_STAGE = EnumProperty.m_61587_((String)"bottom", DragonRootsStage.class);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)11.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)5.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)11.0, (double)14.0, (double)16.0)));

    public DragonRootsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).m_61124_(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS)));
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos offsetPos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(offsetPos).m_60783_((BlockGetter)level, offsetPos, direction);
    }

    public static boolean hasFruit(BlockState state) {
        return DragonRootsBlock.hasFruit(TOP_STAGE, state) || DragonRootsBlock.hasFruit(BOTTOM_STAGE, state);
    }

    public static boolean hasFruit(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.m_61143_(property));
        return stage == DragonRootsStage.FRUIT || stage == DragonRootsStage.FLOWERING || DragonRootsBlock.isEnder(property, state);
    }

    public static boolean isFlowering(BlockState state) {
        return DragonRootsBlock.isFlowering(TOP_STAGE, state) || DragonRootsBlock.isFlowering(BOTTOM_STAGE, state);
    }

    public static boolean isFlowering(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.m_61143_(property));
        return stage == DragonRootsStage.FLOWERING || stage == DragonRootsStage.FLOWERING_ENDER;
    }

    public static boolean isDouble(BlockState state) {
        return state.m_61143_(TOP_STAGE) != DragonRootsStage.NONE && state.m_61143_(BOTTOM_STAGE) != DragonRootsStage.NONE;
    }

    public static boolean isEnder(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.m_61143_(property));
        return stage == DragonRootsStage.ENDER || stage == DragonRootsStage.FLOWERING_ENDER;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!DragonRootsBlock.hasFruit(state) && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (DragonRootsBlock.hasFruit(state)) {
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState newState = state;
            if (DragonRootsBlock.hasFruit(TOP_STAGE, state)) {
                newState = (BlockState)newState.m_61124_(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state)) {
                newState = (BlockState)newState.m_61124_(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            level.m_7731_(pos, newState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
            DragonRootsBlock.dropFruits(state, level, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public static void dropFruits(BlockState state, Level level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (DragonRootsBlock.hasFruit(TOP_STAGE, state)) {
            DragonRootsBlock.addDragonFruitWithOffset(TOP_STAGE, state, level, pos, dir == Direction.NORTH || dir == Direction.EAST ? 0.25f : 0.75f, 0.75f, dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.75f : 0.25f);
        }
        if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state)) {
            DragonRootsBlock.addDragonFruitWithOffset(BOTTOM_STAGE, state, level, pos, dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.75f : 0.25f, 0.25f, dir == Direction.NORTH || dir == Direction.EAST ? 0.75f : 0.25f);
        }
    }

    public void m_6786_(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (!levelAccessor.m_5776_() && DragonRootsBlock.hasFruit(state) && levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            DragonRootsBlock.dropFruits(state, level, pos);
        }
        super.m_6786_(levelAccessor, pos, state);
    }

    public static void addDragonFruitWithOffset(EnumProperty<DragonRootsStage> property, BlockState state, Level level, BlockPos pos, float x, float y, float z) {
        DragonFruit dragonFruit = (DragonFruit)((EntityType)AtmosphericEntityTypes.DRAGON_FRUIT.get()).m_20615_(level);
        dragonFruit.setEnder(DragonRootsBlock.isEnder(property, state));
        dragonFruit.setFlowering(DragonRootsBlock.isFlowering(property, state));
        dragonFruit.m_6034_((float)pos.m_123341_() + x, (float)pos.m_123342_() + y, (float)pos.m_123343_() + z);
        dragonFruit.setRollingDirection((Direction)state.m_61143_((Property)FACING));
        dragonFruit.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
        level.m_7967_((Entity)dragonFruit);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TOP_STAGE, BOTTOM_STAGE});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && !DragonRootsBlock.isDouble(state) || super.m_6864_(state, context);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state;
        Level level = context.m_43725_();
        Direction direction = context.m_43719_();
        if (direction.m_122434_().m_122478_()) {
            direction = context.m_8125_().m_122424_();
        }
        if ((state = level.m_8055_(pos = context.m_8083_())).m_60713_((Block)this) && !DragonRootsBlock.isDouble(state)) {
            if (state.m_61143_(TOP_STAGE) == DragonRootsStage.NONE) {
                return (BlockState)state.m_61124_(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            if (state.m_61143_(BOTTOM_STAGE) == DragonRootsStage.NONE) {
                return (BlockState)state.m_61124_(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
        }
        boolean top = context.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(top ? TOP_STAGE : BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).m_61124_(!top ? TOP_STAGE : BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.NONE));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = state;
        boolean fruitingConditions = level.m_45524_(pos, 0) >= 12 && level.m_46461_() || level.m_45524_(pos, 15) >= 12;
        boolean floweringConditions = level.m_45524_(pos, 0) <= 3 || level.m_45524_(pos, 15) <= 3 && level.m_46462_();
        boolean cropGrew = false;
        if (state.m_61143_(TOP_STAGE) == DragonRootsStage.ROOTS && fruitingConditions && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(10) == 0 ? 1 : 0) != 0)) {
            newState = (BlockState)state.m_61124_(TOP_STAGE, (Comparable)((Object)DragonRootsBlock.getFruitStage(level)));
            cropGrew = true;
        }
        if (state.m_61143_(BOTTOM_STAGE) == DragonRootsStage.ROOTS && fruitingConditions && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(10) == 0 ? 1 : 0) != 0)) {
            newState = (BlockState)state.m_61124_(BOTTOM_STAGE, (Comparable)((Object)DragonRootsBlock.getFruitStage(level)));
            cropGrew = true;
        }
        if (DragonRootsBlock.hasFruit(TOP_STAGE, state) && DragonRootsBlock.isFlowering(TOP_STAGE, state) != floweringConditions) {
            newState = (BlockState)newState.m_61124_(TOP_STAGE, (Comparable)((Object)DragonRootsBlock.switchFruitAndFlowering((DragonRootsStage)((Object)state.m_61143_(TOP_STAGE)))));
        }
        if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state) && DragonRootsBlock.isFlowering(BOTTOM_STAGE, state) != floweringConditions) {
            newState = (BlockState)newState.m_61124_(BOTTOM_STAGE, (Comparable)((Object)DragonRootsBlock.switchFruitAndFlowering((DragonRootsStage)((Object)state.m_61143_(BOTTOM_STAGE)))));
        }
        if (newState != state) {
            level.m_7731_(pos, newState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
            if (cropGrew) {
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !DragonRootsBlock.hasFruit(state);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return world.f_46441_.m_188501_() < 0.3f;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        boolean bottom;
        boolean top = state.m_61143_(TOP_STAGE) == DragonRootsStage.ROOTS;
        boolean bl = bottom = state.m_61143_(BOTTOM_STAGE) == DragonRootsStage.ROOTS;
        if (top || bottom) {
            EnumProperty<DragonRootsStage> property = top && bottom ? (random.m_188499_() ? TOP_STAGE : BOTTOM_STAGE) : (top ? TOP_STAGE : BOTTOM_STAGE);
            level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)((Object)(DragonRootsBlock.isFlowering(state) ? DragonRootsBlock.getFloweringStage(level) : DragonRootsBlock.getFruitStage(level)))));
        }
    }

    public static DragonRootsStage getFruitStage(ServerLevel level) {
        return level.m_220362_().equals((Object)BuiltinDimensionTypes.f_223540_) ? DragonRootsStage.ENDER : DragonRootsStage.FRUIT;
    }

    public static DragonRootsStage switchFruitAndFlowering(DragonRootsStage stage) {
        return stage == DragonRootsStage.FLOWERING ? DragonRootsStage.FRUIT : (stage == DragonRootsStage.FRUIT ? DragonRootsStage.FLOWERING : (stage == DragonRootsStage.FLOWERING_ENDER ? DragonRootsStage.ENDER : (stage == DragonRootsStage.ENDER ? DragonRootsStage.FLOWERING_ENDER : DragonRootsStage.NONE)));
    }

    public static DragonRootsStage getFloweringStage(ServerLevel level) {
        return level.m_220362_().equals((Object)BuiltinDimensionTypes.f_223540_) ? DragonRootsStage.FLOWERING_ENDER : DragonRootsStage.FLOWERING;
    }
}

