/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.state.properties.PassionVineAttachment;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class PassionVineBlock
extends Block
implements BonemealableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    public static final EnumProperty<PassionVineAttachment> ATTACHMENT = EnumProperty.m_61587_((String)"attachment", PassionVineAttachment.class);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public PassionVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> null;
        };
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean randomNum;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean light = level.m_45524_(pos.m_7494_(), 0) >= 5;
        boolean notOld = i < 4;
        boolean canFlower = i >= 1;
        boolean canFruit = notOld && light;
        boolean bl = randomNum = level.f_46441_.m_188503_(2) == 1;
        if (canFlower) {
            if (canFruit) {
                if (randomNum) {
                    this.attemptGrowDown(state, (Level)level, pos, random);
                } else {
                    this.attemptGrowFruit(state, (Level)level, pos, random);
                }
            } else {
                this.attemptGrowDown(state, (Level)level, pos, random);
            }
        } else if (canFruit) {
            this.attemptGrowFruit(state, (Level)level, pos, random);
        }
    }

    public BlockState determineState(BlockState state, LevelReader level, BlockPos pos) {
        boolean vineBelow;
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState above = level.m_8055_(pos.m_7494_());
        boolean vineAbove = above.m_60713_((Block)this) && above.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        boolean bl = vineBelow = below.m_60713_((Block)this) && below.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        if (vineAbove) {
            return vineBelow ? (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.MIDDLE)) : (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.BOTTOM));
        }
        return vineBelow ? (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.TOP)) : (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.NONE));
    }

    public void attemptGrowFruit(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        Direction direction = (Direction)(state = this.determineState(state, (LevelReader)level, pos.m_7495_())).m_61143_((Property)FACING);
        BlockState hanging = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (hanging.m_204336_(AtmosphericBlockTags.PASSION_VINE_GROWABLE_ON)) {
            if (i < 4 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else if (i < 1 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void attemptGrowDown(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0) && level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_46597_(pos.m_7495_(), (BlockState)((BlockState)this.determineState(((Block)AtmosphericBlocks.PASSION_VINE.get()).m_49966_(), (LevelReader)level, pos.m_7495_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 4;
        if (!flag && player.m_21120_(hand).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (flag) {
            PassionVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.PASSION_FRUIT.get(), 1 + level.f_46441_.m_188503_(2) + level.f_46441_.m_188503_(2) + level.f_46441_.m_188503_(3)));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.SUCCESS;
        }
        if (i == 1 && player.m_21120_(hand).m_204117_(Tags.Items.SHEARS)) {
            Direction direction = hit.m_82434_();
            Direction direction1 = direction.m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : direction;
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5 + (double)direction1.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)direction1.m_122431_() * 0.65, new ItemStack((ItemLike)Items.f_42535_, 1));
            itementity.m_20334_(0.05 * (double)direction1.m_122429_() + level.f_46441_.m_188500_() * 0.02, 0.05, 0.05 * (double)direction1.m_122431_() + level.f_46441_.m_188500_() * 0.02);
            level.m_7967_((Entity)itementity);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p_213442_1_ -> p_213442_1_.m_21190_(hand));
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, ATTACHMENT, FACING});
    }

    private boolean canAttachTo(BlockGetter level, BlockPos pos, Direction direction) {
        BlockState blockstate = level.m_8055_(pos);
        return !blockstate.m_60803_() && (blockstate.m_60783_(level, pos, direction) || blockstate.m_204336_(BlockTags.f_13035_));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.m_121945_(direction.m_122424_()), direction) || level.m_8055_(pos.m_7494_()).m_60713_((Block)this) && level.m_8055_(pos.m_7494_()).m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(this.determineState(state, (LevelReader)level, pos), facing, facingState, level, pos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState oppositeState;
        if (!context.m_7058_() && (oppositeState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()))).m_60734_() == this && oppositeState.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        BlockState state = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return this.determineState(state, (LevelReader)level, pos);
        }
        return null;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

